% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{copy.NoiseKriging}
\alias{copy.NoiseKriging}
\alias{copy,NoiseKriging,NoiseKriging-method}
\title{Duplicate a NoiseKriging Model}
\usage{
\method{copy}{NoiseKriging}(object, ...)
}
\arguments{
\item{object}{An S3 NoiseKriging object.}

\item{...}{Not used.}
}
\value{
The copy of object.
}
\description{
Duplicate a NoiseKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X))

k <- NoiseKriging(y, (X/10)^2, X, kernel = "matern3_2", objective="LL")
print(k)

print(copy(k))
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
