% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R
\name{load}
\alias{load}
\title{Load any Kriging Model from a file storage.}
\usage{
load(filename, ...)
}
\arguments{
\item{filename}{A file holding any Kriging object.}

\item{...}{Not used.}
}
\value{
The loaded "*"Kriging object.
}
\description{
Load any Kriging Model from a file storage.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

outfile = tempfile("k.h5") 
save(k,outfile)

print(load(outfile))
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
