% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{as.list.NuggetKriging}
\alias{as.list.NuggetKriging}
\alias{as.list,NuggetKriging,NuggetKriging-method}
\title{Coerce a \code{NuggetKriging} Object into a List}
\usage{
\method{as.list}{NuggetKriging}(x, ...)
}
\arguments{
\item{x}{An object with class \code{"NuggetKriging"}.}

\item{...}{Ignored}
}
\value{
A list with its elements copying the content of the
    \code{NuggetKriging} object fields: \code{kernel}, \code{optim},
    \code{objective}, \code{theta} (vector of ranges),
    \code{sigma2} (variance), \code{X}, \code{centerX},
    \code{scaleX}, \code{y}, \code{centerY}, \code{scaleY},
    \code{regmodel}, \code{F}, \code{T}, \code{M}, \code{z},
    \code{beta}.
}
\description{
Coerce a \code{NuggetKriging} Object into a List
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, kernel = "matern3_2")

l <- as.list(k)
cat(paste0(names(l), " =" , l, collapse = "\n"))
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
