% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimummeancycle.R
\name{MinMeanCycle}
\alias{MinMeanCycle}
\title{Solver for Minimum Mean Cycle}
\usage{
MinMeanCycle(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  algorithm = "Howard"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "Howard", "Karp", and
"HartmannOrlin". "Howard" is the default.}
}
\value{
A list containing two entries: 1) A vector containing the costs of
  each edge in the MMC, and 2) the nodes in the MMC.
}
\description{
Finds the Minimum Mean Cycle in directed graphs.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00614.html}.
}
