% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_label}
\alias{quo_label}
\alias{quo_text}
\alias{quo_name}
\title{Format quosures for printing or labelling}
\usage{
quo_label(quo)

quo_text(quo, width = 60L, nlines = Inf)

quo_name(quo)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{width}{Width of each line.}

\item{nlines}{Maximum number of lines to extract.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\strong{Note:} You should now use \code{\link[=as_label]{as_label()}} or \code{\link[=as_name]{as_name()}} instead
of \code{quo_name()}. See life cycle section below.

These functions take an arbitrary R object, typically an
\link[=is_expression]{expression}, and represent it as a string.
\itemize{
\item \code{quo_name()} returns an abbreviated representation of the object
as a single line string. It is suitable for default names.
\item \code{quo_text()} returns a multiline string. For instance block
expressions like \code{{ foo; bar }} are represented on 4 lines (one
for each symbol, and the curly braces on their own lines).
}

These deparsers are only suitable for creating default names or
printing output at the console. The behaviour of your functions
should not depend on deparsed objects. If you are looking for a way
of transforming symbols to strings, use \code{\link[=as_string]{as_string()}} instead of
\code{quo_name()}. Unlike deparsing, the transformation between symbols
and strings is non-lossy and well defined.
}
\section{Life cycle}{


These functions are superseded.
\itemize{
\item \code{\link[=as_label]{as_label()}} and \code{\link[=as_name]{as_name()}} should be used instead of
\code{quo_name()}. \code{as_label()} transforms any R object to a string
but should only be used to create a default name. Labelisation is
not a well defined operation and no assumption should be made
about the label. On the other hand, \code{as_name()} only works with
(possibly quosured) symbols, but is a well defined and
deterministic operation.
\item We don't have a good replacement for \code{quo_text()} yet. See
\url{https://github.com/r-lib/rlang/issues/636} to follow discussions
about a new deparsing API.
}
}

\examples{
# Quosures can contain nested quosures:
quo <- quo(foo(!! quo(bar)))
quo

# quo_squash() unwraps all quosures and returns a raw expression:
quo_squash(quo)

# This is used by quo_text() and quo_label():
quo_text(quo)

# Compare to the unwrapped expression:
expr_text(quo)

# quo_name() is helpful when you need really short labels:
quo_name(quo(sym))
quo_name(quo(!! sym))
}
\seealso{
\code{\link[=expr_label]{expr_label()}}, \code{\link[=f_label]{f_label()}}
}
\keyword{internal}
