% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_expr}
\alias{parse_expr}
\alias{parse_exprs}
\alias{parse_quo}
\alias{parse_quos}
\title{Parse R code}
\usage{
parse_expr(x)

parse_exprs(x)

parse_quo(x, env)

parse_quos(x, env)
}
\arguments{
\item{x}{Text containing expressions to parse_expr for
\code{parse_expr()} and \code{parse_exprs()}. Can also be an R connection,
for instance to a file. If the supplied connection is not open,
it will be automatically closed and destroyed.}

\item{env}{The environment for the quosures. The \link[=global_env]{global environment} (the default) may be the right choice
when you are parsing external user inputs. You might also want to
evaluate the R code in an isolated context (perhaps a child of
the global environment or of the \link[=base_env]{base environment}).}
}
\value{
\code{parse_expr()} returns an \link[=is_expression]{expression},
\code{parse_exprs()} returns a list of expressions. Note that for the
plural variants the length of the output may be greater than the
length of the input. This would happen is one of the strings
contain several expressions (such as \code{"foo; bar"}). The names of
\code{x} are preserved (and recycled in case of multiple expressions).
The \verb{_quo} suffixed variants return quosures.
}
\description{
These functions parse and transform text into R expressions. This
is the first step to interpret or evaluate a piece of R code
written by a programmer.
\itemize{
\item \code{parse_expr()} returns one expression. If the text contains more
than one expression (separated by semicolons or new lines), an
error is issued. On the other hand \code{parse_exprs()} can handle
multiple expressions. It always returns a list of expressions
(compare to \code{\link[base:parse]{base::parse()}} which returns a base::expression
vector). All functions also support R connections.
\item \code{parse_expr()} concatenates \code{x} with \verb{\\\\n} separators prior to
parsing in order to support the roundtrip
\code{parse_expr(expr_deparse(x))} (deparsed expressions might be
multiline). On the other hand, \code{parse_exprs()} doesn't do any
concatenation because it's designed to support named inputs. The
names are matched to the expressions in the output, which is
useful when a single named string creates multiple expressions.

In other words, \code{parse_expr()} supports vector of lines whereas
\code{parse_exprs()} expects vectors of complete deparsed expressions.
\item \code{parse_quo()} and \code{parse_quos()} are variants that create a
\link[=quo]{quosure}. Supply \code{env = current_env()} if you're parsing
code to be evaluated in your current context. Supply \code{env = global_env()} when you're parsing external user input to be
evaluated in user context.

Unlike quosures created with \code{\link[=enquo]{enquo()}}, \code{\link[=enquos]{enquos()}}, or \verb{\{\{}, a
parsed quosure never contains injected quosures. It is thus safe
to evaluate them with \code{eval()} instead of \code{\link[=eval_tidy]{eval_tidy()}}, though
the latter is more convenient as you don't need to extract \code{expr}
and \code{env}.
}
}
\examples{
# parse_expr() can parse any R expression:
parse_expr("mtcars \%>\% dplyr::mutate(cyl_prime = cyl / sd(cyl))")

# A string can contain several expressions separated by ; or \n
parse_exprs("NULL; list()\n foo(bar)")

# Use names to figure out which input produced an expression:
parse_exprs(c(foo = "1; 2", bar = "3"))

# You can also parse source files by passing a R connection. Let's
# create a file containing R code:
path <- tempfile("my-file.R")
cat("1; 2; mtcars", file = path)

# We can now parse it by supplying a connection:
parse_exprs(file(path))
}
\seealso{
\code{\link[base:parse]{base::parse()}}
}
