% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-defuse.R
\name{enquo0}
\alias{enquo0}
\alias{enquos0}
\title{Defuse arguments without automatic injection}
\usage{
enquo0(arg)

enquos0(...)
}
\arguments{
\item{arg}{A symbol for a function argument to defuse.}

\item{...}{Dots to defuse.}
}
\description{
The 0-suffixed variants of \code{\link[=enquo]{enquo()}} and \code{\link[=enquos]{enquos()}} defuse function
arguments without automatic injection (unquotation). They are
useful when defusing expressions that potentially include \verb{!!},
\verb{!!!}, or \verb{\{\{} operations, for instance tidyverse code. In that
case, \code{enquo()} would process these operators too early, creating a
confusing experience for users. Callers can still inject objects
or expressions using manual injection with \code{\link[=inject]{inject()}}.
}
\details{
None of the features of \link[=dyn-dots]{dynamic dots} are available when
defusing with \code{enquos0()}. For instance, trailing empty arguments
are not automatically trimmed.
}
\examples{
automatic_injection <- function(x) enquo(x)
no_injection <- function(x) enquo0(x)

automatic_injection(foo(!!!1:3))
no_injection(foo(!!!1:3))
}
\seealso{
\code{\link[=enquo]{enquo()}} and \code{\link[=enquos]{enquos()}}
}
