% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-chr.R
\name{as_utf8_character}
\alias{as_utf8_character}
\alias{as_native_character}
\alias{as_utf8_string}
\alias{as_native_string}
\title{Coerce to a character vector and attempt encoding conversion}
\usage{
as_utf8_character(x)

as_native_character(x)

as_utf8_string(x)

as_native_string(x)
}
\arguments{
\item{x}{An object to coerce.}
}
\description{
Unlike specifying the \code{encoding} argument in \code{as_string()} and
\code{as_character()}, which is only declarative, these functions
actually attempt to convert the encoding of their input. There are
two possible cases:
\itemize{
\item The string is tagged as UTF-8 or latin1, the only two encodings
for which R has specific support. In this case, converting to the
same encoding is a no-op, and converting to native always works
as expected, as long as the native encoding, the one specified by
the \code{LC_CTYPE} locale (see \code{\link[=mut_utf8_locale]{mut_utf8_locale()}}) has support for
all characters occurring in the strings. Unrepresentable
characters are serialised as unicode points: "<U+xxxx>".
\item The string is not tagged. R assumes that it is encoded in the
native encoding. Conversion to native is a no-op, and conversion
to UTF-8 should work as long as the string is actually encoded in
the locale codeset.
}

When translating to UTF-8, the strings are parsed for serialised
unicode points (e.g. strings looking like "U+xxxx") with
\code{\link[=chr_unserialise_unicode]{chr_unserialise_unicode()}}. This helps to alleviate the effects of
character-to-symbol-to-character roundtrips on systems with
non-UTF-8 native encoding.
}
\examples{
# Let's create a string marked as UTF-8 (which is guaranteed by the
# Unicode escaping in the string):
utf8 <- "caf\\uE9"
str_encoding(utf8)
as_bytes(utf8)

# It can then be converted to a native encoding, that is, the
# encoding specified in the current locale:
\dontrun{
mut_latin1_locale()
latin1 <- as_native_string(utf8)
str_encoding(latin1)
as_bytes(latin1)
}
}
