% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{as_function}
\alias{as_function}
\alias{as_closure}
\title{Convert to function or closure}
\usage{
as_function(x, env = caller_env())

as_closure(x, env = caller_env())
}
\arguments{
\item{x}{A function or formula.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function
with two arguments, \code{.x} or \code{.} and \code{.y}. This allows you to
create very compact anonymous functions with up to two inputs.}

\item{env}{Environment in which to fetch the function in case \code{x}
is a string.}
}
\description{
\itemize{
\item \code{as_function()} transform objects to functions. It fetches
functions by name if supplied a string or transforms
\link[=quotation]{quosures} to a proper function.
\item \code{as_closure()} first passes its argument to \code{as_function()}. If
the result is a primitive function, it regularises it to a proper
\link{closure} (see \code{\link[=is_function]{is_function()}} about primitive functions).
}
}
\examples{
f <- as_function(~ . + 1)
f(10)

# Primitive functions are regularised as closures
as_closure(list)
as_closure("list")

# Operators have `.x` and `.y` as arguments, just like lambda
# functions created with the formula syntax:
as_closure(`+`)
as_closure(`~`)
}
