% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector-squash.R
\name{splice}
\alias{splice}
\alias{is_spliced}
\alias{is_spliced_bare}
\title{Splice a list within a vector}
\usage{
splice(x)

is_spliced(x)

is_spliced_bare(x)
}
\arguments{
\item{x}{A list to splice.}
}
\description{
This adjective signals to functions taking dots that \code{x} should be
spliced in a surrounding vector. Examples of functions that support
such explicit splicing are \code{\link[=ll]{ll()}}, \code{\link[=chr]{chr()}}, etc. Generally, any
functions taking dots with \code{\link[=dots_list]{dots_list()}} or \code{\link[=dots_splice]{dots_splice()}}
supports splicing.
}
\details{
Note that all functions supporting dots splicing also support the
syntactic operator \code{!!!}. For tidy capture and tidy evaluation,
this operator directly manipulates the calls (see \code{\link[=quo]{quo()}} and
\link{quasiquotation}). However manipulating the call is not appropriate
when taking dots by value rather than by expression, because it is
slow and the dots might contain large lists of data. For this
reason we splice values rather than expressions when dots are not
captured by expression. We do it in two steps: first mark the
objects to be spliced, then splice the objects with \code{\link[=flatten]{flatten()}}.
}
\examples{
x <- list("a")

# It makes sense for ll() to accept lists literally, so it doesn't
# automatically splice them:
ll(x)

# But you can splice lists explicitly:
y <- splice(x)
ll(y)

# Or with the syntactic shortcut:
ll(!!! x)
}
\seealso{
\link{vector-construction}
}
