% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr-lang.R
\name{lang_modify}
\alias{lang_modify}
\title{Modify the arguments of a call}
\usage{
lang_modify(.lang, ..., .standardise = FALSE)
}
\arguments{
\item{.lang}{Can be a call (language object), a formula quoting a
call in the right-hand side, or a frame object from which to
extract the call expression.}

\item{...}{Named or unnamed expressions (constants, names or calls)
used to modify the call. Use \code{NULL} to remove arguments. Dots are
evaluated with \link[=dots_list]{explicit splicing}.}

\item{.standardise}{If \code{TRUE}, the call is standardised before hand
to match existing unnamed arguments to their argument names. This
prevents new named arguments from accidentally replacing original
unnamed arguments.}
}
\value{
A quosure if \code{.lang} is a quosure, a call otherwise.
}
\description{
Modify the arguments of a call
}
\examples{
call <- quote(mean(x, na.rm = TRUE))

# Modify an existing argument
lang_modify(call, na.rm = FALSE)
lang_modify(call, x = quote(y))

# Remove an argument
lang_modify(call, na.rm = NULL)

# Add a new argument
lang_modify(call, trim = 0.1)

# Add an explicit missing argument
lang_modify(call, na.rm = quote(expr = ))

# Supply a list of new arguments with splice()
newargs <- list(na.rm = NULL, trim = 0.1)
lang_modify(call, splice(newargs))

# Supply a call frame to extract the frame expression:
f <- function(bool = TRUE) {
  lang_modify(call_frame(), splice(list(bool = FALSE)))
}
f()


# You can also modify quosures inplace:
f <- ~matrix(bar)
lang_modify(f, quote(foo))
}
\seealso{
lang
}
