% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{Get.Kriging.Parameters}
\alias{Get.Kriging.Parameters}
\title{Get Kriging Parameters}
\usage{
Get.Kriging.Parameters(kriging)
}
\arguments{
\item{kriging}{a kriging class object}
}
\value{
\item{nllh}{negative log-likelihood of the kriging model}
\item{mu}{mean of the kriging model}
\item{nu2}{variance of the kriging model}
\item{sigma2}{variance of the random noise when \code{interpolation=FALSE}}
\item{beta}{coefficients of the basis functions for universal kriging}
\item{c}{c for the rational / generalized rational kriging, see Joseph (2024)}
\item{c0}{c0 for the generalized rational kriging, see Joseph (2024)}
}
\description{
This function can be used for extracting the estimates of the kriging parameters.
}
\examples{
# one dimensional example 
f <- function(x) {
  x <- 0.5 + 2*x
  y <- sin(10*pi*x)/(2*x) + (x-1)^4
  return (y)
}

set.seed(1234)
# train set
n <- 30
p <- 1
X <- matrix(runif(n),ncol=p)
y <- apply(X, 1, f)
newX <- matrix(seq(0,1,length=1001), ncol=p)

kriging <- Fit.Kriging(X, y, interpolation=TRUE, fit=TRUE, model="OK",
                       kernel.parameters=list(type="Gaussian"))
Get.Kriging.Parameters(kriging)

}
\references{
Joseph, V. R. (2006). \emph{Limit kriging}. Technometrics, 48(4), 458-466.

Joseph, V. R. (2024). Rational Kriging. \emph{Journal of the American Statistical Association}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.

Santner, T. J., Williams, B. J., Notz, W. I., & Williams, B. J. (2003). \emph{The design and analysis of computer experiments (Vol. 1)}. New York: Springer.
}
\seealso{
\link{Fit.Kriging}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
