% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-format_var_aliase.R
\name{format_var_aliases}
\alias{format_var_aliases}
\title{Format formula argument list in triplet (type, dimension, position)}
\usage{
format_var_aliases(args)
}
\arguments{
\item{args}{vector of text string, formula input arguments (see Details).}
}
\value{
a list with different information about formula input arguments:
\item{args}{vector of text string, input parameter \code{args}}
\item{var_name}{vector of text string, corresponding name of formula
arguments}
\item{var_type}{vector of text string, corresponding type of formula
arguments (among \code{Vi}, \code{Vj}, \code{Pm}).}
\item{var_pos}{vector of integer, corresponding arguments positions.}
\item{var_aliases}{text string, declaration of formula input arguments for
the C++ KeOps API.}
}
\description{
The function \code{format_var_aliases} formats KeOps formula arguments to be
understood by the C++ code.
}
\details{
Mathematical formula: \verb{sum_i e^(lambda*||x_i - y_j||^2)} where \code{x_i}, \code{y_j}
are 3d vectors, and \code{lambda} is a scaler parameter.

Corresponding KeOps formula and input parameters:\preformatted{formula = "Sum_Reduction(Exp(lambda * SqNorm2(x-y)), 0)"
args = c("x=Vi(3)", "y=Vj(3)", "lambda=Pm(1)")
}

Input arguments can be of different types:

|---------|-------------------------|-----------|
| keyword | meaning                 | type      |
|---------|-------------------------|-----------|
| \code{Vi}    | variable indexed by \code{i} | \code{0}       |
| \code{Vj}    | variable indexed by \code{j} | \code{1}       |
| \code{Pm}    | parameter               | \code{2}       |
|---------|-------------------------|-----------|

An input parameters should be defined as follows \code{"x=YY(dim)"} or
\code{"x=YY(pos, dim)"} where \code{YY} can be \code{Vi}, \code{Vj} or \code{Pm}:
\itemize{
\item \code{dim} is the dimension of the variable or parameter. For \code{Vi} and \code{Vj},
the range of \code{i} or \code{j} is not known at compile time, only at runtime.
\item \code{pos} is the position of the variable as it will be supplied to the
operator, starting from \code{0}. This position should be specify for all
variable or none, if not specify the natural order in the vector \code{args} is
used.
}

For the formula \code{"Sum_Reduction(Exp(lambda * SqNorm2(x-y)), 0)"}, both
\code{args = c("x=Vi(3)", "y=Vj(3)", "lambda=Pm(1)")} and
\code{args <- c("x=Vi(0,3)", "y=Vj(1,3)", "beta=Vj(2,3)", "lambda=Pm(3,1)")} are
equivalent. When specifying the \code{pos} parameter, the natural order in the
vector \code{args} may not correspond to the order of the formula input arguments.

\strong{Note:} we recommand to use the \code{Vi(dim)} notation and let the position be
determined by the argument order.
}
\author{
Ghislain Durif
}
\keyword{internal}
