% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent_tsn.R
\name{parent_tsn}
\alias{parent_tsn}
\title{Returns the parent TSN for the entered TSN.}
\usage{
parent_tsn(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame
}
\description{
Returns the parent TSN for the entered TSN.
}
\examples{
\dontrun{
parent_tsn(tsn = 202385)
parent_tsn(tsn = 202385, raw = TRUE)
parent_tsn(tsn = 202385, wt = "xml")
}
}

