% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec_pos}
\alias{dec_pos}
\title{Number of individuals for which the decision is positive.}
\format{An object of class \code{numeric} of length 1.}
\usage{
dec_pos
}
\description{
\code{dec_pos} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is positive (i.e., called or predicted cases).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec_pos} individuals depends on the population size \code{\link{N}} and
the decision's proportion of positive decisions \code{\link{ppod}} and is split further into two subsets of
\code{\link{hi}} by the positive predictive value \code{\link{PPV}} and
\code{\link{fa}} by the false detection rate \code{\link{FDR} = 1 - \link{PPV}}.

Perspectives:

\enumerate{
  \item by condition:

The frequency \code{\link{dec_pos}} is determined by the population size \code{\link{N}} times
  the proportion of positive decisions \code{\link{ppod}}:

\code{\link{dec_pos}  =  \link{N} x \link{ppod}}

\item by decision:

a. The frequency \code{\link{hi}} is determined by \code{\link{dec_pos}} times the positive predictive value \code{\link{PPV}}
  (aka. \code{\link{precision}}):

\code{\link{hi}  =  \link{dec_pos} x \link{PPV}}

b. The frequency \code{\link{fa}} is determined by \code{\link{dec_pos}} times the false detection rate \code{\link{FDR} = (1 - \link{PPV})}:

\code{\link{fa}  =  \link{dec_pos} x \link{FDR}  =  \link{dec_pos} x (1 - \link{PPV})}

}

\item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

\itemize{

\item \code{\link{N}  =  \link{cond_true} + \link{cond_false}} (by condition)

\item \code{\link{N}  =  \link{dec_pos} + \link{dec_neg}} (by decision)

\item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

\item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec_pos <- 1000 * .33   # => sets dec_pos to 33\% of 1000 = 330 cases.
is_freq(dec_pos)        # => TRUE
is_prob(dec_pos)        # => FALSE, as dec_pos is no probability (but ppod and PPV are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{N}},
  \code{\link{cond_false}}, \code{\link{cond_true}},
  \code{\link{cr}}, \code{\link{dec_cor}},
  \code{\link{dec_err}}, \code{\link{dec_neg}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
