% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{N}
\alias{N}
\title{Number of individuals in the population.}
\format{An object of class \code{numeric} of length 1.}
\usage{
N
}
\description{
\code{N} is a frequency that describes the
number of individuals in the current population
(i.e., the overall number of cases considered).
}
\details{
Key relationships between frequencies and probabilities
(see documentation of \code{\link{comp_freq}} or \code{\link{comp_prob}} for details):

\itemize{

\item Three perspectives on a population:

by condition / by decision / by accuracy.

\item Defining probabilities in terms of frequencies:

Probabilities can be computed as ratios between frequencies, but beware of rounding issues.

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
N <- 1000   # => sets a population size of 1000
is_freq(N)  # => TRUE
is_prob(N)  # => FALSE (as N is no probability)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Statistical_population}{Wikipedia: Statistical population} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{cond_false}},
  \code{\link{cond_true}}, \code{\link{cr}},
  \code{\link{dec_cor}}, \code{\link{dec_err}},
  \code{\link{dec_neg}}, \code{\link{dec_pos}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
