% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec.pos}
\alias{dec.pos}
\title{Number of individuals for which the decision is positive.}
\format{An object of class \code{numeric} of length 1.}
\usage{
dec.pos
}
\description{
\code{dec.pos} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is positive (i.e., called or predicted cases).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec.pos} individuals depends on the population size \code{\link{N}} and
the decision's proportion of positive decisions \code{\link{ppod}} and is split further into two subsets of
\code{\link{hi}} by the positive predictive value \code{\link{PPV}} and
\code{\link{fa}} by the false detection rate \code{\link{FDR} = 1 - \link{PPV}}.

Perspectives:

\enumerate{
  \item by condition:

The frequency \code{\link{dec.pos}} is determined by the population size \code{\link{N}} times
  the proportion of positive decisions \code{\link{ppod}}:

\code{\link{dec.pos}  =  \link{N} x \link{ppod}}

\item by decision:

a. The frequency \code{\link{hi}} is determined by \code{\link{dec.pos}} times the positive predictive value \code{\link{PPV}}
  (aka. \code{\link{precision}}):

\code{\link{hi}  =  \link{dec.pos} x \link{PPV}}

b. The frequency \code{\link{fa}} is determined by \code{\link{dec.pos}} times the false detection rate \code{\link{FDR} = (1 - \link{PPV})}:

\code{\link{fa}  =  \link{dec.pos} x \link{FDR}  =  \link{dec.pos} x (1 - \link{PPV})}

}

\item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

\itemize{

\item \code{\link{N}  =  \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N}  =  \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec.pos <- 1000 * .33   # => sets dec.pos to 33\% of 1000 = 330 cases.
is_freq(dec.pos)        # => TRUE
is_prob(dec.pos)        # => FALSE, as dec.pos is no probability (but ppod and PPV are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cond.true}},
  \code{\link{cr}}, \code{\link{dec.cor}},
  \code{\link{dec.err}}, \code{\link{dec.neg}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\keyword{datasets}
