% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_FOR}
\alias{comp_FOR}
\title{Compute a decision's false omission rate (FOR) from probabilities.}
\usage{
comp_FOR(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
The false omission rate \code{\link{FOR}} as a probability.
A warning is provided for NaN values.
}
\description{
\code{comp_FOR} computes the false omission rate \code{\link{FOR}}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_FOR} uses probabilities (not frequencies)
and does not round results.
}
\examples{
# (1) Ways to work:
comp_FOR(.50, .500, .500)  # => FOR = 0.5    = (1 - NPV)
comp_FOR(.50, .333, .666)  # => FOR = 0.5004 = (1 - NPV)


}
\seealso{
\code{\link{comp_spec}} and \code{\link{comp_NPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_NPV}}, \code{\link{comp_PPV}},
  \code{\link{comp_accu}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}
}
