% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badges.R
\name{list_badges}
\alias{list_badges}
\title{List badges image URLs from a local README}
\usage{
list_badges(path)
}
\arguments{
\item{path}{Character scalar; path to a local README file (e.g., "README.md").}
}
\value{
data.frame with badge info
}
\description{
Scans a local README (Markdown) and returns badge image URLs.
}
\examples{
\dontrun{
tmp <- tempfile(fileext = ".md")
writeLines(c(
  "# MyPkg",
  "![build](build-status.svg)",
  "![cov](coverage.svg)"
), tmp)
out <- list_badges(tmp)
print(out)
}
}
