% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{imkdir}
\alias{imkdir}
\title{Create a New Collection in iRODS}
\usage{
imkdir(logical_path, create_parent_collections = FALSE, verbose = FALSE)
}
\arguments{
\item{logical_path}{Path to the collection to create, relative to the current
working directory (see \code{\link[=ipwd]{ipwd()}}).}

\item{create_parent_collections}{Whether parent collections should be created
when necessary. Defaults to \code{FALSE}.}

\item{verbose}{Whether information about the HTTP request and response
should be printed. Defaults to \code{FALSE}.}
}
\value{
Invisibly the HTTP request.
}
\description{
This is the equivalent to \code{\link[=dir.create]{dir.create()}}, but creating a collection in iRODS
instead of a local directory.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authentication
iauth("rods", "rods")

# list all object and collection in the current collection of iRODS
ils()

# create a new collection
imkdir("new_collection")

# check if it is there
ils()

# and move to the new directory
icd("new_collection")

# remove collection
icd("..")
irm("new_collection", force = TRUE, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=irm]{irm()}} for removing collections,
\code{\link[=dir.create]{dir.create()}} for an R equivalent.
}
