% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_read.r
\name{read_ipums_sf}
\alias{read_ipums_sf}
\alias{read_ipums_sp}
\title{Read boundary files from an IPUMS extract}
\usage{
read_ipums_sf(shape_file, shape_layer = NULL, bind_multiple = TRUE,
  verbose = TRUE)

read_ipums_sp(shape_file, shape_layer = NULL, bind_multiple = TRUE,
  verbose = TRUE)
}
\arguments{
\item{shape_file}{Filepath to one or more .shp files or a .zip file from an IPUMS extract}

\item{shape_layer}{For .zip extracts with multiple datasets, the name of the
 shape files to load. Accepts a character vector specifying the file name, or
\code{\link{dplyr_select_style}} conventions. Can load multiple shape files,
  which will be combined.}

\item{bind_multiple}{If \code{TRUE}, will combine multiple shape files found into
a single object.}

\item{verbose}{I \code{TRUE}, will report progress information}
}
\value{
\code{read_ipums_sf} returns a sf object and \code{read_ipums_sp} returns
  a SpatialPolygonsDataFrame.
}
\description{
Reads the boundary files from an IPUMS extract into R as simple features (sf) objects or
SpatialPolygonsDataFrame (sp) objects.
}
\examples{
shape_file <- ripums_example("nhgis0008_shape_small.zip")
# If sf package is availble, can load as sf object
if (require(sf)) {
  sf_data <- read_ipums_sf(shape_file)
}

# If sp package is available, can load as SpatialPolygonsDataFrame
if (require(sp) && require(rgdal)) {
  sp_data <- read_ipums_sp(shape_file)
}

}
\seealso{
Other ipums_read: \code{\link{read_ipums_micro}},
  \code{\link{read_nhgis}}, \code{\link{read_terra_area}},
  \code{\link{read_terra_micro}},
  \code{\link{read_terra_raster}}
}
