% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introjs.R
\name{introjsUI}
\alias{introjsUI}
\title{Set up Shiny app to use intro.js}
\usage{
introjsUI(includeOnly = FALSE)
}
\arguments{
\item{includeOnly}{Only include intro.js files. For users who will write their own javascript}
}
\description{
This function must be called from a Shiny app's UI in order
to use the package.
}
\examples{
\dontrun{
library(rintrojs)
library(shiny)

shinyApp(
ui = fluidPage(
  introjsUI(), # must include in UI
  actionButton("btn", "Click me")
),
server = function(input, output, session) {
  observeEvent(input$btn, {
    intro <- data.frame(element="#btn",
                        intro="In Codd we trust")
    introjs(session, options = list(steps= intro))
  })
}
)
}
}

