% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calBP.14C}
\alias{calBP.14C}
\title{Find the 14C age and error belonging to a cal BP age.}
\usage{
calBP.14C(yr, cc = 1, postbomb = FALSE, rule = 1, ccdir = NULL)
}
\arguments{
\item{yr}{The cal BP year.}

\item{cc}{calibration curve for C14 (see \code{caldist()}).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{rule}{How should R's approx function deal with extrapolation. If \code{rule=1}, the default, then NAs are returned for such points and if it is 2, the value at the closest data extreme is used.}

\item{ccdir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{ccdir="curves"}.}
}
\value{
The calibration-curve 14C year belonging to the entered cal BP age
}
\description{
Given a calendar age, the calibration curve (default cc=1) is interpolated and the corresponding 14C age and error are returned.
}
\details{
Interpolation is used, and values outside the calibration curve are given as NA. For negative cal BP ages, a postbomb curve will have to be provided.
}
\examples{
calBP.14C(100)
}
\author{
Maarten Blaauw
}
