% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutualinfo.R
\name{mutual_info}
\alias{mutual_info}
\title{Mutual Information}
\usage{
mutual_info(series, local = FALSE)
}
\arguments{
\item{series}{Matrix specifying a set of time series.}

\item{local}{Boolean specifying whether to compute the local mutual
information.}
}
\value{
Numeric giving the average mutual information or a vector giving the
        local mutual information.
}
\description{
Compute the average or the local mutual information between two or more time series.
Each variable can have a different base.
}
\examples{
series      <- matrix(0, nrow = 20, ncol = 2)
series[, 1] <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1)
series[, 2] <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1)
mutual_info(series)    # 0.2141709

# [1] -1.0, -1.0, 0.2223924, 0.2223924, 0.2223924, 0.2223924, 0.2223924,
#     0.2223924, 0.2223924, 0.2223924, 0.2223924, 0.2223924, 0.2223924, 0.2223922,
#     0.2223924, 0.2223924, 1.5849625, 1.5849625, 1.5849625, -1.5849625
mutual_info(series, local = TRUE)
}
