% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{integrate_generalized_lorenz_curve}
\alias{integrate_generalized_lorenz_curve}
\title{Integrate generalized Lorenz curve}
\usage{
integrate_generalized_lorenz_curve(dep_var, weights)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.
The default (\code{NULL)} is equivalent to \code{weights = rep(1, length(dep_var))}.}
}
\value{
the size of the area under the lorenz curve (the integrated lorenz curve).
}
\description{
Computes the area under the lorenz curve.
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
integrated_lorenz_curve <-
  integrate_generalized_lorenz_curve(
    dep_var = dep_var,
    weights = weights
  )

}
