% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_check_linux}
\alias{local_check_linux}
\title{Run a package check locally, in a Docker container}
\usage{
local_check_linux(
  path = ".",
  quiet = FALSE,
  image = NULL,
  valgrind = FALSE,
  check_args = character(),
  env_vars = character(),
  timeout = Inf,
  artifacts = tempfile()
)
}
\arguments{
\item{path}{Path to a directory containing an R package, or path to
source R package tarball built with \verb{R CMD build} or
\code{devtools::build()}.}

\item{quiet}{Whether to print the check output}

\item{image}{Docker image to use. If \code{NULL}, a default image is selected.}

\item{valgrind}{Whether to run the check with Valgrind.}

\item{check_args}{Extra arguments for the \verb{R CMD check} command.}

\item{env_vars}{Environment variables to set on the builder machine
before the check. A named character vector.}

\item{timeout}{Timeout for a check, a \code{difftime} object or a scalar
that will be interpreted as seconds.}

\item{artifacts}{Where to copy the build artifacts after the build.}
}
\value{
An \code{rcmdcheck::rcmdcheck} object, with extra fields:
\itemize{
\item \code{all_output}: all output from the check, both standard output and
error.
\item \code{container_name}: name of the Docker container that performed the
build. It is a random name.
\item \code{artifacts}: directory of build artifacts.
}
}
\description{
Run a package check locally, in a Docker container. UNTESTED
ON WINDOWS, bug reports welcome. :-)
}
\details{
You'll need to have bash and Docker installed.
}
