% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSimulatedCodeSet.R
\name{createSimulatedCodeSet}
\alias{createSimulatedCodeSet}
\title{Create Simulated codeSet}
\usage{
createSimulatedCodeSet(length, baserate, kappaMin, kappaMax, precisionMin,
  precisionMax)
}
\arguments{
\item{length}{the length of the simulated \code{\link{codeSet}} to be created}

\item{baserate}{the \code{\link{baserate}} of the simulated \code{\link{codeSet}}}

\item{kappaMin}{the minimum kappa of the simulated \code{\link{codeSet}}}

\item{kappaMax}{the maximum kappa of the simulated \code{\link{codeSet}}}

\item{precisionMin}{the minimum precision of the simulated \code{\link{codeSet}}}

\item{precisionMax}{the maximum precision of the simulated \code{\link{codeSet}}}
}
\value{
A \code{\link{codeSet}} that fulfills the given parameters
}
\description{
Creates a simulated \code{\link{codeSet}} with the given parameters
}
\details{
\code{\link{codeSet}}s are generated by first picking a random kappa within its range and a random precision within its range.  If the random kappa, random precision, and baserate are not mathematically possible, then the precision is resampled from a range of mathematically possible values within its range.  A unique simulated \code{\link{codeSet}} is then constructed given these parameters.
}
\keyword{codeSet,}
\keyword{create}

