% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_mean_pred.R
\name{geom_mean_pred}
\alias{geom_mean_pred}
\title{Calculation of Geometric Mean for Geographic Profiling}
\usage{
geom_mean_pred(lat, lon)
}
\arguments{
\item{lat}{a vector of latitudes for the crime incident series}

\item{lon}{a vector of latitudes for the crime incident series}
}
\value{
A latitude and longitude point of the geometric mean of the incidents.
    This mean can be used to prioritize the area which contains the offender's
    anchor point.
}
\description{
A calculation of the geometric mean for serial crime
    analysis. This function is among the centrographic methods which have
    been used for geographic profiling. The model assumes that the serial
    perpetrator's home base is relatively central among the crime incidents.
}
\examples{
#Using provided dataset for the Boston Strangler Incidents:
data(desalvo)
geom_mean_pred(desalvo$lat, desalvo$lon)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{methods}
\keyword{spatial}
