% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd_pred.R
\name{cmd_pred}
\alias{cmd_pred}
\title{Calculation of Center of Minimum Distance for Geographic Profiling}
\usage{
cmd_pred(lat, lon)
}
\arguments{
\item{lat}{a vector of latitudes for the crime incident series}

\item{lon}{a vector of latitudes for the crime incident series}
}
\value{
A latitude and longitude point of the center of minimum distance of
    the incidents. This mean can be used to prioritize the area which contains
    the offender's anchor point.
}
\description{
A calculation of the center of minimum distance for serial crime
    analysis. This function is among the centrographic methods which have
    been used for geographic profiling. The model assumes that the serial
    perpetrator's home base is relatively central among the crime incidents.
}
\examples{
#Using provided dataset for the Boston Strangler Incidents:
data(desalvo)
cmd_pred(desalvo$lat, desalvo$lon)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{methods}
\keyword{spatial}
