% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_fdr}
\alias{lisa_fdr}
\title{False Discovery Rate value of local spatial autocorrelation}
\usage{
lisa_fdr(gda_lisa, current_p)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}

\item{current_p}{A value of current siginificant p-value}
}
\value{
A numeric vector of False Discovery Rate
}
\description{
Get False Discovery Rate value based on current LISA computation and current significant p-value
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
lisa <- local_moran(queen_w, guerry["Crm_prs"])
fdr <- lisa_fdr(lisa, 0.05)
fdr
}
}
