% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{gb_cache}
\alias{gb_cache}
\alias{gb_set_cache}
\alias{gb_get_cache}
\alias{gb_clear_cache}
\alias{gb_list_cache}
\alias{gb_delete_from_cache}
\title{Caching geoBoundaries downloaded files}
\usage{
gb_set_cache(path)

gb_get_cache(create = FALSE)

gb_clear_cache(force = FALSE)

gb_list_cache(full_path = FALSE)

gb_delete_from_cache(file)
}
\arguments{
\item{path}{character; path of the directory to set}

\item{create}{logical; if TRUE create missing cache}

\item{force}{logical; force delete. default: \code{FALSE}}

\item{full_path}{logical; if TRUE returns the full path of the file}

\item{file}{Character, the file to delete}
}
\value{
the cache directory

list of files in the cache
}
\description{
Manage cached geoBoundaries downloaded files
}
\details{
The default cache directory is
\verb{~/.cache/R/gb_cache}, but you can set
your own path using \code{gb_set_cache(path)}
}
\note{
This function will clear all cached files
}
\examples{
\donttest{
## change the default cache directory
tmp <- tempdir()
gb_set_cache(tmp)

## print current cache directory
cache_dir <- gb_get_cache(create = TRUE)

urls <- file.path("https://github.com/wmgeolab/geoBoundaries",
        "raw/c0ed7b8/releaseData/gbOpen/HND/ADM0",
        "geoBoundaries-HND-ADM0-all.zip")
destfiles <- file.path(cache_dir, basename(urls))
if (!all(file.exists(destfiles)) | isTRUE(force)) {
lapply(seq_along(urls), \(i)
        download.file(urls[i],
                        destfile = destfiles[i],
                        quiet = TRUE))
}
## List available files in the current cache directory
gb_list_cache()

l <- gb_list_cache()[1] ## get the first file
gb_delete_from_cache(l) ## delete it

gb_clear_cache() ## delete all cached files
}
}
