% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{gd_search}
\alias{gd_search}
\title{Search an Image Collection}
\usage{
gd_search(
  x,
  region,
  start_date = "2000-01-01",
  end_date = as.character(Sys.Date()),
  ...
)
}
\arguments{
\item{x}{\code{geedim.collection.MaskedCollection} object}

\item{region}{list / Python GeoJSON object describing region, e.g. as created by \code{gd_bbox()}}

\item{start_date}{Default: \code{'2020-01-01'}}

\item{end_date}{Default: \code{Sys.Date()}}

\item{...}{additional arguments to \code{geedim.MaskedCollection.search()} e.g. \code{cloudless_portion}, \code{fill_portion}}
}
\value{
\code{geedim.MaskedCollection} object suitable for querying properties
}
\description{
Search an Image Collection
}
\examples{
\dontshow{if (gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
\donttest{
b <- terra::vect('POLYGON((-121.355 37.56,-121.355 37.555,
                    -121.35 37.555,-121.35 37.56,
                    -121.355 37.56))',
          crs = "OGC:CRS84")
if (gd_is_initialized())
  gd_search(gd_collection_from_name("USGS/3DEP/1m"),
            region = gd_region(b))
}
}
