% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_print.R
\name{ee_print}
\alias{ee_print}
\alias{ee_print.ee.geometry.Geometry}
\alias{ee_print.ee.feature.Feature}
\alias{ee_print.ee.featurecollection.FeatureCollection}
\alias{ee_print.ee.image.Image}
\alias{ee_print.ee.imagecollection.ImageCollection}
\title{Print and return metadata about Spatial Earth Engine Objects}
\usage{
ee_print(eeobject, ...)

\method{ee_print}{ee.geometry.Geometry}(eeobject, ..., clean = FALSE, quiet = FALSE)

\method{ee_print}{ee.feature.Feature}(eeobject, ..., clean = FALSE, quiet = FALSE)

\method{ee_print}{ee.featurecollection.FeatureCollection}(eeobject, ..., f_index = 0, clean = FALSE, quiet = FALSE)

\method{ee_print}{ee.image.Image}(
  eeobject,
  ...,
  img_band,
  time_end = TRUE,
  compression_ratio = 20,
  clean = FALSE,
  quiet = FALSE
)

\method{ee_print}{ee.imagecollection.ImageCollection}(
  eeobject,
  ...,
  time_end = TRUE,
  img_index = 0,
  img_band,
  compression_ratio = 20,
  clean = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{eeobject}{Earth Engine Object. Available for: Geometry, Feature,
FeatureCollection, Image or ImageCollection.}

\item{...}{ignored}

\item{clean}{Logical. If TRUE, the cache will be cleaned.}

\item{quiet}{Logical. Suppress info message}

\item{f_index}{Numeric. Index of the \code{ee$FeatureCollection} to fetch.
Relevant just for \code{ee$FeatureCollection} objects.}

\item{img_band}{Character. Band name of the \code{ee$Image} to fetch.
Relevant just for \code{ee$ImageCollection} and \code{ee$Image} objects.}

\item{time_end}{Logical. If TRUE, the system:time_end property in ee$Image
is also returned. See \code{rgee::ee_get_date_img} for details.}

\item{compression_ratio}{Numeric. Measurement of the relative reduction
in size of data representation produced by a data compression algorithm
(ignored if \code{eeobject} is not a Image or ImageCollection). By default
is 20.}

\item{img_index}{Numeric. Index of the \code{ee$ImageCollection} to fetch.
Relevant just for \code{ee$ImageCollection} objects.}
}
\value{
A list with the metadata of the Earth Engine object.
}
\description{
Print and return metadata about Spatial Earth Engine Objects.
\code{ee_print} can retrieve information about the number of images
or features, number of bands or geometries, number of pixels, geotransform,
data type, properties and object size.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

# Geometry
geom <- ee$Geometry$Rectangle(-10,-10,10,10)
Map$addLayer(geom)
ee_print(geom)

# Feature
feature <- ee$Feature(geom, list(rgee = "ee_print", data = TRUE))
ee_print(feature)

# FeatureCollection
featurecollection <- ee$FeatureCollection(feature)
ee_print(featurecollection)

# Image
srtm <- ee$Image("CGIAR/SRTM90_V4")
ee_print(srtm)

srtm_clip <- ee$Image("CGIAR/SRTM90_V4")$clip(geom)
srtm_metadata <- ee_print(srtm_clip)
srtm_metadata$img_bands_names

# ImageCollection
object <- ee$ImageCollection("LANDSAT/LC08/C01/T1_TOA")$
  filter(ee$Filter()$eq("WRS_PATH", 44))$
  filter(ee$Filter()$eq("WRS_ROW", 34))$
  filterDate("2014-03-01", "2014-08-01")$
  aside(ee_print)
}
}
\seealso{
Other helper functions: 
\code{\link{ee_help}()},
\code{\link{ee_monitoring}()}
}
\concept{helper functions}
