% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_list.R
\name{occ_download_list}
\alias{occ_download_list}
\title{Lists the downloads created by a user.}
\usage{
occ_download_list(user = NULL, pwd = NULL, limit = 20, start = 0,
  curlopts = list())
}
\arguments{
\item{user}{(character) User name within GBIF's website. Required. See
Details.}

\item{pwd}{(character) User password within GBIF's website. Required. See
Details.}

\item{limit}{Number of records to return. Default: 20}

\item{start}{Record number to start at. Default: 0}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\description{
Lists the downloads created by a user.
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
occ_download_list(user="sckott")
occ_download_list(user="sckott", limit = 5)
occ_download_list(user="sckott", start = 21)
}
}
