% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots-data.R
\name{rfm_barchart_data}
\alias{rfm_barchart_data}
\title{Bar chart data}
\usage{
rfm_barchart_data(rfm_table)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}
}
\description{
Data for generating bar charts.
}
\examples{
# using transaction data
analysis_date <- lubridate::as_date('2006-12-31', tz = 'UTC')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# bar chart data
rfm_barchart_data(rfm_order)

# using customer data
analysis_date <- lubridate::as_date('2007-01-01', tz = 'UTC')
rfm_customer <- rfm_table_customer(rfm_data_customer, customer_id,
number_of_orders, recency_days, revenue, analysis_date)

# bar chart data
rfm_barchart_data(rfm_customer)

}
