% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fishdraw.R
\name{get_polylines}
\alias{get_polylines}
\title{Get outputs polylines (supported format svg, json, csv, etc.)}
\usage{
get_polylines(
  path = "./fishdraw.js",
  name = NULL,
  format = "svg",
  output = "output.svg",
  draw_type = "random"
)
}
\arguments{
\item{path}{Path for fishdraw.js or customs.js via \code{\link{custom_params}}}

\item{name}{The name string is used as the name of the fish (printed in the drawing). If unspecified, a random pseudo-Latin name will be auto generated.}

\item{format}{Format options: svg (regular svg), smil (animated svg), csv (each polyline on a comma-separated line) and json.}

\item{output}{Outputs polylines (supported format svg, json, csv, etc.)}

\item{draw_type}{Draw_type options: random(by design fishdraw.js program is for randomly generated fishes),custom(by create and implement a custom customs.js for your favorite fish).}
}
\value{
Get outputs fish drawings polylines (in format .svg, .json and .csv).
}
\description{
Get outputs polylines (supported format svg, json, csv, etc.)
}
\examples{
\dontrun{
# Get outputs polylines in svg
get_polylines(path = "inst/fishdraw.js",
              format = "svg",
              output = "output.svg",
              draw_type = "random")

# Get outputs polylines in json
get_polylines(path = "inst/fishdraw.js",
              format = "json",
              output = "output.json",
              draw_type = "random")

# Get outputs polylines in smil
get_polylines(path = "inst/fishdraw.js",
              format = "smil",
              output = "output.svg",
              draw_type = "random")

# browse animated svg
browseURL("inst/animated.svg")
}
}
\author{
Liuyong Ding \email{ly_ding@126.com}
}
