% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parquet_db.R
\name{fb_import}
\alias{fb_import}
\title{Import tables to local store}
\usage{
fb_import(
  server = c("fishbase", "sealifebase"),
  version = get_latest_release(),
  db = fb_conn(server, version),
  tables = NULL
)
}
\arguments{
\item{server}{fishbase or sealifebase}

\item{version}{release version}

\item{db}{A cachable duckdb database connection}

\item{tables}{list of tables to import. Default `NULL` will
import all tables.}
}
\description{
Import tables to local store
}
\details{
Downloads and stores tables from the requested version of 
fishbase or sealifebase.  If the table is already downloaded, it will
not be re-downloaded.  Imported tables are added to the active duckdb
connection. Note that there is no need to call this
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
conn <- fb_import()
\dontshow{\}) # examplesIf}
}
