% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_names.R
\name{sci_to_common}
\alias{sci_to_common}
\title{sci_to_common}
\usage{
sci_to_common(species_list, Language = NULL, limit = 1000,
  server = getOption("FISHBASE_API", FISHBASE_API))
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, the table will be loaded up to the limit. This makes it possible to load an entire table without knowledge of the species in the table, thus avoiding uneccesary API calls.}

\item{Language}{the language for the common name, see details.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}
}
\value{
The common name, if it exists
}
\description{
Return the preferred FishBase common name given a scientific name (or speccode)
}
\details{
If Language is NULL, the common name is 
the preferred FishBase common name (in English).  Otherwise it 
is the most frequently used common name (which may not be the same
as the FishBase common name even with English as the requested Language)
}
\examples{
\dontrun{
sci_to_common("Salmo trutta")
sci_to_common("Salmo trutta", Language="English")
sci_to_common("Salmo trutta", Language="French")
}
}

