% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_extendr.R
\name{use_extendr}
\alias{use_extendr}
\title{Set up a package for use with Rust extendr code}
\usage{
use_extendr(path = ".", quiet = getOption("usethis.quiet", FALSE))
}
\arguments{
\item{path}{File path to the package for which to generate wrapper code.}

\item{quiet}{Logical indicating whether any progress messages should be
generated or not. Also checks the \code{usethis.quiet} option.}
}
\value{
A logical value (invisible) indicating whether any package files were
generated or not.
}
\description{
Create the scaffolding needed to add Rust extendr code to an R package. \code{use_extendr()}
adds a small Rust library with a single Rust function that returns the string
\code{"Hello world!"}. It also adds wrapper code so this Rust function can be called from
R with \code{hello_world()}.
}
\details{
To avoid possibly messing up your R package, \code{use_extendr()} will not do anything if
either a directory \code{src} or a file \code{R/extendr-wrappers.R} is already present in your
package source.
}
