% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revealjs_presentation.R
\name{revealjs_presentation}
\alias{revealjs_presentation}
\title{Convert to a reveal.js presentation}
\usage{
revealjs_presentation(incremental = FALSE, center = FALSE,
  slide_level = 2, fig_width = 8, fig_height = 6, fig_retina = if
  (!fig_caption) 2, fig_caption = FALSE, smart = TRUE,
  self_contained = TRUE, theme = "simple", transition = "default",
  background_transition = "default", reveal_options = NULL,
  reveal_plugins = NULL, highlight = "default", mathjax = "default",
  template = "default", css = NULL, includes = NULL, keep_md = FALSE,
  lib_dir = NULL, pandoc_args = NULL, extra_dependencies = NULL, ...)
}
\arguments{
\item{incremental}{\code{TRUE} to render slide bullets incrementally. Note
that if you want to reverse the default incremental behavior for an
individual bullet you can precede it with \code{>}. For example:
\emph{\code{> - Bullet Text}}}

\item{center}{\code{TRUE} to vertically center content on slides}

\item{slide_level}{Level of heading to denote individual slides. If
\code{slide_level} is 2 (the default), a two-dimensional layout will be
produced, with level 1 headers building horizontally and level 2 headers
building vertically. It is not recommended that you use deeper nesting of
section levels with reveal.js.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, --- to em-dashes, -- to en-dashes, and ... to
ellipses.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
it's size).}

\item{theme}{Visual theme ("simple", "sky", "beige", "serif", "solarized",
"blood", "moon", "night", "black", "league" or "white").}

\item{transition}{Slide transition ("default", "none", "fade", "slide",
"convex", "concave" or "zoom")}

\item{background_transition}{Slide background-transition ("default", "none",
"fade", "slide", "convex", "concave" or "zoom")}

\item{reveal_options}{Additional options to specify for reveal.js (see
\href{https://github.com/hakimel/reveal.js#configuration}{https://github.com/hakimel/reveal.js#configuration}
for details).}

\item{reveal_plugins}{Reveal plugins to include. Available plugins include
"notes", "search", "zoom", "chalkboard", and "menu". Note that
\code{self_contained} must be set to \code{FALSE} in order to use Reveal
plugins.}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from
the official MathJax CDN. The "local" option uses a local version of MathJax
(which is copied into the output directory). You can pass an alternate URL
or pass \code{NULL} to exclude MathJax entirely.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've
created. Note that if you don't use the "default" template then some
features of \code{revealjs_presentation} won't be available (see the
Templates section below for more details).}

\item{css}{One or more css files to include}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\code{_files} appended to it.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{extra_dependencies}{Additional function arguments to pass to the base R
Markdown HTML output formatter \code{\link[rmarkdown:html_document_base]{rmarkdown::html_document_base()}}.}

\item{...}{Ignored}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to a reveal.js presentation.
}
\details{
In reveal.js presentations you can use level 1 or level 2 headers for slides.
If you use a mix of level 1 and level 2 headers then a two-dimensional layout
will be produced, with level 1 headers building horizontally and level 2
headers building vertically.

For additional documentation on using revealjs presentations see
\href{https://github.com/rstudio/revealjs}{https://github.com/rstudio/revealjs}.
}
\examples{
\dontrun{

library(rmarkdown)
library(revealjs)

# simple invocation
render("pres.Rmd", revealjs_presentation())

# specify an option for incremental rendering
render("pres.Rmd", revealjs_presentation(incremental = TRUE))
}


}
