% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprior.R
\name{rprior_prob}
\alias{rprior_prob}
\title{Prior simulation of GEV parameters - prior on probability scale}
\usage{
rprior_prob(n, quant, alpha, exc = FALSE, lb = NULL, lb_prob = 0.001)
}
\arguments{
\item{n}{A numeric scalar. The size of sample required.}

\item{quant}{A numeric vector of length 3.  Contains quantiles
\eqn{q_1, q_2, q_3}.  A prior distribution is placed on the
non-exceedance (\code{exc = FALSE}) or exceedance (\code{exc = TRUE})
probabilities corresponding to these quantiles.
The values should \emph{increase} with the index of the vector.
If not, the values in \code{quant} will be sorted into increasing order
without warning.}

\item{alpha}{A numeric vector of length 4. Parameters of the Dirichlet
distribution for the exceedance probabilities.}

\item{exc}{A logical scalar.  Let \eqn{M} be the GEV variable,
\eqn{r_q = P(M \leq q)}{r_q = P(M <= q)},
\eqn{p_q = P(M > q) = 1 - r_q} and
\code{quant} = (\eqn{q_1, q_2, q_3}).
If \code{exc = FALSE} then a Dirichlet(\code{alpha}) distribution is
placed on
\eqn{(r_{q_1}, r_{q_2} - r_{q_1}, r_{q_3} - r_{q_2}, 1 - r_{q_3})}{%
      (r_q1, r_q2 - r_q1, r_q3 - r_q2, 1 - r_q3)}, as in
Northrop et al. (2017).
If \code{exc = TRUE} then a Dirichlet(\code{alpha}) distribution
is placed on
\eqn{(1 - p_{q_1}, p_{q_1} - p_{q_2}, p_{q_2} - p_{q_3}, p_{q_3})}{%
     (1 - p_q1, p_q1 - p_q2, p_q2 - p_q3, p_q3)}, where
\eqn{p_q = P(M > q)}, as in Stephenson (2016).}

\item{lb}{A numeric scalar.  If this is not \code{NULL} then the simulation
is constrained so that \code{lb} is an approximate lower bound on the
GEV variable.  Specifically, only simulated GEV parameter values for
which the 100\code{lb_prob}\% quantile is greater than \code{lb} are
retained.}

\item{lb_prob}{A numeric scalar.  The non-exceedance probability involved
in the specification of \code{lb}.  Must be in (0,1).  If \code{lb=NULL}
then \code{lb_prob} is not used.}
}
\value{
An \code{n} by 3 numeric matrix.
}
\description{
Simulates from the prior distribution for GEV parameters based on
Crowder (1992), in which independent beta priors are specified
for ratios of probabilities (which is equivalent to
a Dirichlet prior on differences between these probabilities).
}
\details{
The simulation is based on the way that the prior is constructed.
  See
  \href{https://doi.org/10.1201/b19721}{Stephenson (1996)}
  the evdbayes user guide or Northrop et al. (2017)
  \href{https://doi.org/10.1111/rssc.12159}{Northrop et al. (2017)}
  for details of the construction of the prior.  First, differences between
  probabilities are simulated from a Dirichlet distribution. Then the GEV
  location, scale and shape parameters that correspond to these quantile
  values are found, by solving numerically a set of three non-linear
  equations in which the GEV quantile function evaluated at the simulated
  probabilities is equated to the quantiles in \code{quant}.
  This is reduced to a one-dimensional optimisation over the GEV shape
  parameter.
}
\examples{
quant <- c(85, 88, 95)
alpha <- c(4, 2.5, 2.25, 0.25)
x <- rprior_prob(n = 1000, quant = quant, alpha = alpha, exc = TRUE)
x <- rprior_prob(n = 1000, quant = quant, alpha = alpha, exc = TRUE, lb = 0)
}
\references{
Crowder, M. (1992) Bayesian priors based on parameter
  transformation using the distribution function.
  \emph{Ann. Inst. Statist. Math.}, \strong{44}(3), 405-416.
  \url{https://link.springer.com/article/10.1007/BF00050695}

Stephenson, A. 2016. Bayesian Inference for Extreme Value
  Modelling. In \emph{Extreme Value Modeling and Risk Analysis: Methods and
  Applications}, edited by D. K. Dey and J. Yan, 257-80. London:
  Chapman and Hall. \url{https://doi.org/10.1201/b19721}

Northrop, P. J., Attalides, N. and Jonathan, P. (2017)
  Cross-validatory extreme value threshold selection and uncertainty
  with application to ocean storm severity.
  \emph{Journal of the Royal Statistical Society Series C: Applied
  Statistics}, \strong{66}(1), 93-120.
  \url{https://doi.org/10.1111/rssc.12159}
}
\seealso{
\code{\link[evdbayes:prior]{prior.prob}} to set this prior using
  the evdbayes package.

\code{\link[evdbayes]{posterior}}: evdbayes function that can
  sample from this prior distribution (using MCMC) if the argument
  \code{lh = "none"} is given.

\code{\link{rpost}} and \code{\link{rpost_rcpp}} for sampling
  from an extreme value posterior distribution.
}
