% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gp_norm}
\alias{gp_norm}
\title{Bivariate normal prior for GP parameters (\eqn{log \sigma, \xi})}
\usage{
gp_norm(pars, mean, icov, min_xi = -Inf, max_xi = Inf, trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 2.
GP parameters (\eqn{\sigma, \xi}).}

\item{mean}{A numeric vector of length 2.  Prior mean.}

\item{icov}{A 2x2 numeric matrix.
The inverse of the prior covariance matrix.}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatability with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
