/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.integer;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;

@Explained
public final class IntAffineView<I extends IntVar>
extends IntView<I> {
    public final boolean p;
    public final int a;
    public final int b;

    public IntAffineView(I var, int a, int b) {
        super(a + ".(" + var.getName() + ") + " + b, var);
        this.p = a >= 0;
        this.a = Math.abs(a);
        this.b = b;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return (IntAffineView.this.p ? value : -value) * IntAffineView.this.a + IntAffineView.this.b;
            }
        };
    }

    @Override
    public boolean removeValue(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        int inf = this.getLB();
        int sup = this.getUB();
        if (inf > value || value > sup) {
            return false;
        }
        value -= this.b;
        if (this.a > 1) {
            if (value % this.a != 0) {
                return false;
            }
            value /= this.a;
        }
        if (!this.p) {
            value = -value;
        }
        if (this.var.removeValue(value, this, reason)) {
            IntEventType e = IntEventType.REMOVE;
            if (value == inf) {
                e = IntEventType.INCLOW;
            } else if (value == sup) {
                e = IntEventType.DECUPP;
            }
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        value -= this.b;
        if (this.a > 1) {
            if (value % this.a != 0) {
                if (this.getModel().getSolver().isLCG()) {
                    this.getModel().getSolver().getSat().cEnqueue(0, reason);
                }
                this.contradiction(this, "the variable is already instantiated to another value");
            }
            value /= this.a;
        }
        if (!this.p) {
            value = -value;
        }
        if (this.var.instantiateTo(value, this, reason)) {
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause, Reason reason) throws ContradictionException {
        boolean change;
        assert (cause != null);
        int old = this.getLB();
        if (old >= value) {
            return false;
        }
        --value;
        value -= this.b;
        if (this.a > 1) {
            value = value / this.a - (value % this.a < 0 ? 1 : 0);
        }
        if (change = !this.p ? this.var.updateUpperBound(-value - 1, this, reason) : this.var.updateLowerBound(value + 1, this, reason)) {
            IntEventType e = IntEventType.INCLOW;
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause, Reason reason) throws ContradictionException {
        boolean change;
        assert (cause != null);
        int old = this.getUB();
        if (old <= value) {
            return false;
        }
        value -= this.b;
        if (this.a > 1) {
            value = value / this.a - (value % this.a < 0 ? 1 : 0);
        }
        if (change = !this.p ? this.var.updateLowerBound(-value, this, reason) : this.var.updateUpperBound(value, this, reason)) {
            IntEventType e = IntEventType.DECUPP;
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = IntAffineView.this.var.getValueIterator(IntAffineView.this.p);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = IntAffineView.this.var.getValueIterator(!IntAffineView.this.p);
                }

                @Override
                public boolean hasNext() {
                    return IntAffineView.this.p ? this.vit.hasNext() : this.vit.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return IntAffineView.this.p ? this.vit.hasPrevious() : this.vit.hasNext();
                }

                @Override
                public int next() {
                    return (IntAffineView.this.p ? this.vit.next() : -this.vit.previous()) * IntAffineView.this.a + IntAffineView.this.b;
                }

                @Override
                public int previous() {
                    return (IntAffineView.this.p ? this.vit.previous() : -this.vit.next()) * IntAffineView.this.a + IntAffineView.this.b;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = this.a == 1 ? new DisposableRangeIterator(){
                DisposableRangeIterator rit;
                int min;
                int max;

                @Override
                public void bottomUpInit() {
                    this.rit = IntAffineView.this.var.getRangeIterator(IntAffineView.this.p);
                    if (IntAffineView.this.p) {
                        this.min = this.rit.min() + IntAffineView.this.b;
                        this.max = this.rit.max() + IntAffineView.this.b;
                    } else {
                        this.min = -this.rit.max() + IntAffineView.this.b;
                        this.max = -this.rit.min() + IntAffineView.this.b;
                    }
                }

                @Override
                public void topDownInit() {
                    this.rit = IntAffineView.this.var.getRangeIterator(!IntAffineView.this.p);
                    if (IntAffineView.this.p) {
                        this.min = this.rit.min() + IntAffineView.this.b;
                        this.max = this.rit.max() + IntAffineView.this.b;
                    } else {
                        this.min = -this.rit.max() + IntAffineView.this.b;
                        this.max = -this.rit.min() + IntAffineView.this.b;
                    }
                }

                @Override
                public boolean hasNext() {
                    return IntAffineView.this.p ? this.rit.hasNext() : this.rit.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return IntAffineView.this.p ? this.rit.hasPrevious() : this.rit.hasNext();
                }

                @Override
                public void next() {
                    if (IntAffineView.this.p) {
                        this.rit.next();
                        this.min = this.rit.min() + IntAffineView.this.b;
                        this.max = this.rit.max() + IntAffineView.this.b;
                    } else {
                        this.rit.previous();
                        this.min = -this.rit.max() + IntAffineView.this.b;
                        this.max = -this.rit.min() + IntAffineView.this.b;
                    }
                }

                @Override
                public void previous() {
                    if (IntAffineView.this.p) {
                        this.rit.previous();
                        this.min = this.rit.min() + IntAffineView.this.b;
                        this.max = this.rit.max() + IntAffineView.this.b;
                    } else {
                        this.rit.next();
                        this.min = -this.rit.max() + IntAffineView.this.b;
                        this.max = -this.rit.min() + IntAffineView.this.b;
                    }
                }

                @Override
                public int min() {
                    return this.min;
                }

                @Override
                public int max() {
                    return this.max;
                }
            } : new DisposableRangeIterator(){
                DisposableValueIterator vit;
                int min;
                int max;
                boolean iterable;

                @Override
                public void bottomUpInit() {
                    this.vit = IntAffineView.this.getValueIterator(true);
                    this.iterable = this.vit.hasNext();
                    this.min = this.max = this.vit.next();
                }

                @Override
                public void topDownInit() {
                    this.vit = IntAffineView.this.getValueIterator(false);
                    this.iterable = this.vit.hasPrevious();
                    this.min = this.max = this.vit.previous();
                }

                @Override
                public boolean hasNext() {
                    boolean isIterable = this.iterable;
                    this.iterable = this.vit.hasNext();
                    return isIterable;
                }

                @Override
                public boolean hasPrevious() {
                    boolean isIterable = this.iterable;
                    this.iterable = this.vit.hasPrevious();
                    return isIterable;
                }

                @Override
                public void next() {
                    this.min = this.max = this.vit.next();
                }

                @Override
                public void previous() {
                    this.min = this.max = this.vit.previous();
                }

                @Override
                public int min() {
                    return this.min;
                }

                @Override
                public int max() {
                    return this.max;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public boolean contains(int value) {
        value -= this.b;
        if (this.a > 1) {
            if (value % this.a != 0) {
                return false;
            }
            value /= this.a;
        }
        value = !this.p ? -value : value;
        return this.var.contains(value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiated() && this.contains(value);
    }

    @Override
    public int getValue() throws IllegalStateException {
        if (!this.isInstantiated()) {
            throw new IllegalStateException("getValue() can be only called on instantiated variable. " + this.name + " is not instantiated");
        }
        return (this.p ? this.var.getValue() : -this.var.getValue()) * this.a + this.b;
    }

    @Override
    public int getLB() {
        return (!this.p ? -this.var.getUB() : this.var.getLB()) * this.a + this.b;
    }

    @Override
    public int getUB() {
        return (!this.p ? -this.var.getLB() : this.var.getUB()) * this.a + this.b;
    }

    @Override
    public int nextValue(int v) {
        if (v < this.getLB()) {
            return this.getLB();
        }
        if (v > this.getUB()) {
            return Integer.MAX_VALUE;
        }
        v = (v -= this.b) < 0 && this.a > 1 && v % this.a != 0 ? v - this.a : v;
        v /= this.p ? this.a : -this.a;
        v = this.p ? this.var.nextValue(v) : this.var.previousValue(v);
        if (v == Integer.MIN_VALUE || v == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (this.p ? v : -v) * this.a + this.b;
    }

    @Override
    public int nextValueOut(int v) {
        if (++v < this.getLB() || v > this.getUB()) {
            return v;
        }
        double w = v - this.b;
        int k = (int)(w /= (double)(this.p ? this.a : -this.a));
        if (w == (double)k && this.var.contains(k)) {
            if (this.a > 1) {
                ++v;
            } else {
                k = this.p ? this.var.nextValueOut(k) : this.var.previousValueOut(k);
                v = (this.p ? k : -k) * this.a + this.b;
            }
        }
        return v;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.getUB()) {
            return this.getUB();
        }
        if (v < this.getLB()) {
            return Integer.MIN_VALUE;
        }
        v = (v -= this.b) > 0 && this.a > 1 && v % this.a != 0 ? v + this.a : v;
        v /= this.p ? this.a : -this.a;
        v = this.p ? this.var.previousValue(v) : this.var.nextValue(v);
        if (v == Integer.MIN_VALUE || v == Integer.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (this.p ? v : -v) * this.a + this.b;
    }

    @Override
    public int previousValueOut(int v) {
        if (--v < this.getLB() || v > this.getUB()) {
            return v;
        }
        double w = v - this.b;
        int k = (int)(w /= (double)(this.p ? this.a : -this.a));
        if (w == (double)k && this.var.contains(k)) {
            if (this.a > 1) {
                --v;
            } else {
                k = this.p ? this.var.previousValueOut(k) : this.var.nextValueOut(k);
                v = (this.p ? k : -k) * this.a + this.b;
            }
        }
        return v;
    }

    protected EvtScheduler<IntEventType> createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return this.getName() + "[" + this.getLB() + "," + this.getUB() + "]";
    }

    @Override
    public IEventType transformEvent(IEventType evt) {
        if (evt == IntEventType.INCLOW) {
            if (!this.p) {
                return IntEventType.DECUPP;
            }
        } else if (evt == IntEventType.DECUPP && !this.p) {
            return IntEventType.INCLOW;
        }
        return evt;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return this.var.hasEnumeratedDomain() || this.a > 1;
    }

    public boolean equals(IntVar v, int a, int b) {
        if (!this.var.equals(v)) {
            return false;
        }
        return this.a == Math.abs(a) && this.b == b && this.p == a >= 0;
    }

    @Override
    public int getLit(int val, int t) {
        val -= this.b;
        if (this.a > 1) {
            int k = val % this.a;
            val /= this.a;
            if (k != 0) {
                if (t == 0) {
                    throw new SolverException("Cannot compute lit from " + this + " and " + val + " and " + t);
                }
                if (t == 1) {
                    throw new SolverException("Check falseLit");
                }
                if (t == 2 && k > 0) {
                    ++val;
                }
                if (t == 3 && k < 0) {
                    --val;
                }
            }
        }
        if (!this.p) {
            val = -val;
            if (t >= 2) {
                assert (5 - t >= 0);
                return this.var.getLit(val, 5 - t);
            }
        }
        return this.var.getLit(val, t);
    }

    @Override
    public int getMinLit() {
        return this.p ? this.var.getMinLit() : this.var.getMaxLit();
    }

    @Override
    public int getMaxLit() {
        return this.p ? this.var.getMaxLit() : this.var.getMinLit();
    }

    @Override
    public int getValLit() {
        return this.var.getValLit();
    }
}

