% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_connected_constraint.R
\name{add_connected_constraint}
\alias{add_connected_constraint}
\title{Add constraint to ensure that the selected planning units for restoration
are connected.}
\usage{
add_connected_constraint(problem)
}
\arguments{
\item{problem}{\code{\link[=restopt_problem]{restopt_problem()}} Restoration problem object.}
}
\value{
An updated restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object.
}
\description{
Add constraint to a restoration problem (\code{\link[=restopt_problem]{restopt_problem()}}) object
to specify the selected planning units are connected
}
\details{
A connected area is such that there is a path between any to
planning units within the area. This constraints applies on the set of
planning units that are selected for restoration. In practice, this
constraint is useful to ensure the feasibility of a restoration project,
and to integrate economies of scale. Connected restoration areas are
usually associated with lower costs, because it ensures that restoration
sites are not too far away from each other (e.g. lower travel
costs between sites, less areas to monitor, etc.). \strong{Note} This constraint
relies on the add_components_constraint(), with parameters set to enforce
exactly one connected component. Also see \link{add_components_constraint}
and \link{add_compactness_constraint}.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
    existing_habitat = habitat_data,
    aggregation_factor = 16,
    habitat_threshold = 0.7
  ) \%>\%
  add_restorable_constraint(
    min_restore = 10,
    max_restore = 100,
  ) \%>\%
  add_connected_constraint()

# plot preprocessed data
plot(rast(list(p$data$existing_habitat, p$data$restorable_habitat)), nc = 2)

# print problem
print(p)

# Solve problem
s <- solve(p)
# plot solution
plot(s)
}

}
\seealso{
Other constraints: 
\code{\link{add_available_areas_constraint}()},
\code{\link{add_compactness_constraint}()},
\code{\link{add_components_constraint}()},
\code{\link{add_locked_out_constraint}()},
\code{\link{add_min_iic_constraint}()},
\code{\link{add_min_mesh_constraint}()},
\code{\link{add_restorable_constraint}()}
}
\concept{constraints}
