/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.iterable;

import java.util.Arrays;
import java.util.function.IntConsumer;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.objects.setDataStructures.AbstractSet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class IntIterableRangeSet
extends AbstractSet
implements IntIterableSet {
    public static final int MIN = -1073741823;
    public static final int MAX = 0x3FFFFFFF;
    protected int[] ELEMENTS;
    protected int SIZE;
    protected int CARDINALITY;
    private ISetIterator iter;
    private boolean lock;

    private void checkInvariants() {
        assert (this.SIZE <= this.ELEMENTS.length);
        assert ((this.SIZE & 1) == 0);
        assert (this.CARDINALITY >= 0);
    }

    public IntIterableRangeSet() {
        this.ELEMENTS = new int[10];
        this.SIZE = 0;
        this.CARDINALITY = 0;
    }

    public IntIterableRangeSet(int a2, int b) {
        if (a2 > b) {
            throw new IndexOutOfBoundsException("Incorrect bounds [" + a2 + "," + b + "]");
        }
        this.ELEMENTS = new int[10];
        this.SIZE = 2;
        this.CARDINALITY = Math.addExact(b + 1, -a2);
        this.ELEMENTS[0] = a2;
        this.ELEMENTS[1] = b;
    }

    public IntIterableRangeSet(int e) {
        this.ELEMENTS = new int[10];
        this.SIZE = 2;
        this.CARDINALITY = 1;
        this.ELEMENTS[0] = this.ELEMENTS[1] = e;
    }

    public IntIterableRangeSet(int[] values) {
        this();
        this.addAll(values);
    }

    public IntIterableRangeSet(IntVar var) {
        this();
        this.copyFrom(var);
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder();
        if (this.SIZE == 0) {
            st.append('\u2205');
        } else {
            for (int i = 0; i < this.SIZE - 1; i += 2) {
                if (i == 0 && this.ELEMENTS[i] == -1073741823) {
                    st.append('(').append("-\u221e");
                } else {
                    st.append('[').append(this.ELEMENTS[i]);
                }
                st.append(',');
                if (this.ELEMENTS[i + 1] == 0x3FFFFFFF) {
                    st.append("+\u221e").append(")\u222a");
                    continue;
                }
                st.append(this.ELEMENTS[i + 1]).append("]\u222a");
            }
            st.deleteCharAt(st.length() - 1);
        }
        return st.toString();
    }

    public String toSmartString() {
        StringBuilder st = new StringBuilder();
        st.append("{");
        for (int i = 0; i < this.SIZE - 1; i += 2) {
            if (this.ELEMENTS[i] == this.ELEMENTS[i + 1]) {
                st.append(this.ELEMENTS[i]).append(',');
                continue;
            }
            st.append(this.ELEMENTS[i]).append("..").append(this.ELEMENTS[i + 1]).append(',');
        }
        if (this.SIZE > 0) {
            st.deleteCharAt(st.length() - 1);
        }
        st.append("}");
        return st.toString();
    }

    public void lock() {
        this.lock = XParameters.ALLOW_LOCK;
    }

    public void unlock() {
        this.lock = false;
    }

    public int getNbRanges() {
        return this.SIZE >> 1;
    }

    public int cardinality() {
        return this.CARDINALITY;
    }

    public int minOfRange(int r) {
        return this.ELEMENTS[r << 1];
    }

    public int maxOfRange(int r) {
        return this.ELEMENTS[(r << 1) + 1];
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find minimum of an empty set");
        }
        return this.ELEMENTS[0];
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot find maximum of an empty set");
        }
        return this.ELEMENTS[this.SIZE - 1];
    }

    @Override
    public boolean add(int e) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        boolean modified = false;
        int p = this.rangeOf(e);
        if (p < 0) {
            this.grow(this.SIZE + 2);
            int i = -p - 1 << 1;
            int c = i > 0 && this.ELEMENTS[i - 1] + 1 == e ? 1 : 0;
            switch (c += i < this.SIZE && e == this.ELEMENTS[i] - 1 ? 2 : 0) {
                case 0: {
                    System.arraycopy(this.ELEMENTS, i, this.ELEMENTS, i + 2, this.SIZE - i);
                    int n = e;
                    this.ELEMENTS[i + 1] = n;
                    this.ELEMENTS[i] = n;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    assert (this.ELEMENTS[i - 1] + 1 == e);
                    this.ELEMENTS[i - 1] = e;
                    break;
                }
                case 2: {
                    assert (this.ELEMENTS[i] - 1 == e);
                    this.ELEMENTS[i] = e;
                    break;
                }
                case 3: {
                    System.arraycopy(this.ELEMENTS, i + 1, this.ELEMENTS, i - 1, this.SIZE - i);
                    this.SIZE -= 2;
                    break;
                }
                default: {
                    throw new SolverException("Unexpected mask " + c);
                }
            }
            modified = true;
            ++this.CARDINALITY;
            this.notifyObservingElementAdded(e);
        }
        return modified;
    }

    @Override
    public boolean addAll(int ... values) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        for (int i = 0; i < values.length; ++i) {
            this.add(values[i]);
        }
        return this.CARDINALITY - c > 0;
    }

    @Override
    public boolean addAll(IntIterableSet set) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        if (set.isEmpty()) {
            return false;
        }
        int c = this.CARDINALITY;
        if (!set.isEmpty()) {
            int v = set.min();
            while (v < Integer.MAX_VALUE) {
                this.add(v);
                v = set.nextValue(v);
            }
        }
        return this.CARDINALITY > c;
    }

    public boolean addAll(IntVar var) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        DisposableRangeIterator rit = var.getRangeIterator(true);
        while (rit.hasNext()) {
            this.addBetween(rit.min(), rit.max());
            rit.next();
        }
        return this.CARDINALITY < c;
    }

    public boolean addAll(IntIterableRangeSet set) {
        int s2;
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        if (!set.isEmpty() && (s2 = set.SIZE >> 1) > 0) {
            int j = 0;
            do {
                this.addBetween(set.ELEMENTS[j << 1], set.ELEMENTS[(j << 1) + 1]);
            } while (++j < s2);
        }
        return this.CARDINALITY < c;
    }

    @Override
    public boolean retainAll(IntIterableSet set) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        if (set.isEmpty()) {
            this.clear();
        } else {
            int last = this.max();
            int i = this.min();
            while (i <= last) {
                if (!set.contains(i)) {
                    this.remove(i);
                }
                i = this.nextValue(i);
            }
        }
        return c - this.CARDINALITY > 0;
    }

    public boolean retainAll(IntIterableRangeSet set) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        if (set.isEmpty()) {
            this.clear();
            return c - this.CARDINALITY > 0;
        }
        boolean b = IntIterableSetUtils.intersectionOf(this, set);
        if (b) {
            this.notifyObservingFullUpdate();
        }
        return b;
    }

    @Override
    public boolean remove(int e) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        boolean modified = false;
        int p = this.rangeOf(e);
        if (p >= 0) {
            int i = p - 1 << 1;
            int c = this.ELEMENTS[i] == e ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == e ? 2 : 0) {
                case 0: {
                    this.grow(this.SIZE + 2);
                    System.arraycopy(this.ELEMENTS, i + 1, this.ELEMENTS, i + 3, this.SIZE - i - 1);
                    this.ELEMENTS[i + 1] = e - 1;
                    this.ELEMENTS[i + 2] = e + 1;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    int n = i;
                    this.ELEMENTS[n] = this.ELEMENTS[n] + 1;
                    break;
                }
                case 2: {
                    int n = i + 1;
                    this.ELEMENTS[n] = this.ELEMENTS[n] - 1;
                    break;
                }
                case 3: {
                    System.arraycopy(this.ELEMENTS, i + 2, this.ELEMENTS, i, this.SIZE - i - 2);
                    this.SIZE -= 2;
                    break;
                }
                default: {
                    throw new SolverException("Unexpected mask " + c);
                }
            }
            modified = true;
            --this.CARDINALITY;
            this.notifyObservingElementRemoved(e);
        }
        return modified;
    }

    @Override
    public boolean removeAll(IntIterableSet set) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        if (!set.isEmpty()) {
            int v = set.min();
            while (v < Integer.MAX_VALUE) {
                this.remove(v);
                v = set.nextValue(v);
            }
        }
        return this.CARDINALITY < c;
    }

    public boolean removeAll(IntIterableRangeSet set) {
        int s2;
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int c = this.CARDINALITY;
        if (!set.isEmpty() && (s2 = set.SIZE >> 1) > 0) {
            int j = 0;
            do {
                this.removeBetween(set.ELEMENTS[j << 1], set.ELEMENTS[(j << 1) + 1]);
            } while (++j < s2);
        }
        return this.CARDINALITY < c;
    }

    @Override
    public void clear() {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        this.CARDINALITY = 0;
        this.SIZE = 0;
        this.notifyObservingCleared();
    }

    @Override
    public SetType getSetType() {
        return SetType.RANGESET;
    }

    public boolean addBetween(int a2, int b) {
        boolean change;
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        if (a2 > b) {
            throw new IndexOutOfBoundsException("Incorrect bounds [" + a2 + "," + b + "]");
        }
        int s1 = this.SIZE >> 1;
        int s2 = 1;
        if (s1 > 0) {
            int newCapacity;
            int oldCapacity;
            int ubi;
            int lbi;
            int i = 0;
            int j = 0;
            int s = 0;
            int c = 0;
            int[] e = new int[this.SIZE];
            int lb = lbi = this.ELEMENTS[0];
            int ub = ubi = this.ELEMENTS[1];
            int lbj = a2;
            int ubj = b;
            if (lb > lbj) {
                lb = lbj;
                ub = ubj;
            }
            while (i < s1 || j < s2) {
                boolean extend = false;
                if (lb - 1 <= lbi && lbi <= ub + 1) {
                    ub = Math.max(ub, ubi);
                    boolean bl = extend = i < s1;
                    if (++i < s1) {
                        lbi = this.ELEMENTS[i << 1];
                        ubi = this.ELEMENTS[(i << 1) + 1];
                    }
                }
                if (lb - 1 <= lbj && lbj <= ub + 1) {
                    ub = Math.max(ub, ubj);
                    extend |= j < s2;
                    ++j;
                }
                if (extend) continue;
                if (s + 2 > e.length) {
                    oldCapacity = e.length;
                    newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity < s + 2) {
                        newCapacity = s + 2;
                    }
                    e = Arrays.copyOf(e, newCapacity);
                }
                e[s++] = lb;
                e[s++] = ub;
                c += ub - lb + 1;
                if (i < s1) {
                    lb = lbi;
                    ub = ubi;
                    if (j >= s2 || lbi <= lbj) continue;
                    lb = lbj;
                    ub = ubj;
                    continue;
                }
                if (j >= s2) continue;
                lb = lbj;
                ub = ubj;
            }
            if (s + 2 > e.length) {
                oldCapacity = e.length;
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < s + 2) {
                    newCapacity = s + 2;
                }
                e = Arrays.copyOf(e, newCapacity);
            }
            e[s++] = lb;
            e[s++] = ub;
            this.ELEMENTS = e;
            this.SIZE = s;
            change = this.CARDINALITY != (c += ub - lb + 1);
            this.CARDINALITY = c;
        } else {
            this.grow(1);
            this.ELEMENTS[0] = a2;
            this.ELEMENTS[1] = b;
            this.SIZE = 2;
            this.CARDINALITY = Math.addExact(b + 1, -a2);
            change = true;
        }
        if (change) {
            this.notifyObservingAddedBetween(a2, b);
        }
        return change;
    }

    @Override
    public boolean removeBetween(int f, int t) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        boolean rem = false;
        if (f > t) {
            throw new IllegalArgumentException("Cannot remove from empty range [" + f + "," + t + "]");
        }
        int rf = this.rangeOf(f);
        if (rf < 0) {
            if ((rf *= -1) > this.SIZE >> 1) {
                return false;
            }
            f = this.ELEMENTS[rf - 1 << 1];
        }
        assert (rf > 0);
        int rt = this.rangeOf(t, rf - 1 << 1, this.SIZE);
        if (rt < 0) {
            if ((rt = -rt - 1) < 1) {
                return false;
            }
            t = this.ELEMENTS[(rt - 1 << 1) + 1];
        }
        assert (rt > 0);
        int i = rf - 1 << 1;
        int j = rt - 1 << 1;
        if (rf <= rt) {
            int dcard = -(f - this.ELEMENTS[i] + this.ELEMENTS[j + 1] - t);
            dcard += this.ELEMENTS[i + 1] - this.ELEMENTS[i] + 1;
            if (rf < rt) {
                for (int k = i + 2; k <= j + 1; k += 2) {
                    dcard += this.ELEMENTS[k + 1] - this.ELEMENTS[k] + 1;
                }
                System.arraycopy(this.ELEMENTS, j + 1, this.ELEMENTS, i + 1, this.SIZE - (j + 1));
                this.SIZE -= rt - rf << 1;
            }
            this.CARDINALITY -= dcard;
            int c = this.ELEMENTS[i] == f ? 1 : 0;
            switch (c += this.ELEMENTS[i + 1] == t ? 2 : 0) {
                case 0: {
                    this.grow(this.SIZE + 2);
                    System.arraycopy(this.ELEMENTS, i, this.ELEMENTS, i + 2, this.SIZE - i);
                    this.ELEMENTS[i + 1] = f - 1;
                    this.ELEMENTS[i + 2] = t + 1;
                    this.SIZE += 2;
                    break;
                }
                case 1: {
                    this.ELEMENTS[i] = t + 1;
                    break;
                }
                case 2: {
                    this.ELEMENTS[i + 1] = f - 1;
                    break;
                }
                case 3: {
                    if (i < this.SIZE - 2) {
                        System.arraycopy(this.ELEMENTS, i + 2, this.ELEMENTS, i, this.SIZE - (i + 2));
                    }
                    this.SIZE -= 2;
                }
            }
            rem = true;
        }
        if (rem) {
            this.notifyObservingRemovedBetween(f, t);
        }
        return rem;
    }

    public boolean retainBetween(int f, int t) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        if (f > t) {
            throw new IllegalArgumentException("Cannot retain from empty range [" + f + "," + t + "]");
        }
        if (this.isEmpty() || f <= this.min() && t >= this.max()) {
            return false;
        }
        int rf = this.rangeOf(f);
        if (rf < 0) {
            if ((rf *= -1) << 1 > this.SIZE) {
                this.clear();
                return true;
            }
            f = this.ELEMENTS[rf - 1 << 1];
        }
        assert (rf > 0);
        int rt = this.rangeOf(t, rf - 1 << 1, this.SIZE);
        if (rt < 0) {
            if ((rt = -rt - 1) < 1) {
                this.clear();
                return true;
            }
            t = this.ELEMENTS[(rt - 1 << 1) + 1];
        }
        assert (rt > 0);
        int i = rf - 1 << 1;
        int j = rt - 1 << 1;
        if (rf <= rt) {
            this.ELEMENTS[i] = f;
            this.ELEMENTS[j + 1] = t;
            System.arraycopy(this.ELEMENTS, i, this.ELEMENTS, 0, j - i + 2);
            this.SIZE = rt - rf + 1 << 1;
            this.CARDINALITY = 0;
            for (int k = 0; k < this.SIZE; k += 2) {
                this.CARDINALITY += this.ELEMENTS[k + 1] - this.ELEMENTS[k] + 1;
            }
            this.notifyObservingRetainedBetween(f, t);
        } else {
            this.clear();
        }
        return true;
    }

    @Override
    public int nextValue(int e) {
        int p = this.rangeOf(++e);
        int next = Integer.MAX_VALUE;
        if (p == -1 && this.SIZE > 0) {
            next = this.ELEMENTS[0];
        } else if (p >= 0) {
            next = e;
        } else if (p > -((this.SIZE >> 1) + 1)) {
            return this.ELEMENTS[-p - 1 << 1];
        }
        return next;
    }

    @Override
    public int nextValueOut(int e) {
        int p;
        int next = (p = this.rangeOf(++e)) >= 0 ? this.ELEMENTS[(p - 1 << 1) + 1] + 1 : e;
        return next;
    }

    @Override
    public int previousValue(int e) {
        int p = this.rangeOf(--e);
        int prev = Integer.MIN_VALUE;
        if (p == -((this.SIZE >> 1) + 1) && this.SIZE > 0) {
            prev = this.ELEMENTS[this.SIZE - 1];
        } else if (p >= 0) {
            prev = e;
        } else if (p < -1) {
            prev = this.ELEMENTS[(-p - 1 << 1) - 1];
        }
        return prev;
    }

    @Override
    public int previousValueOut(int e) {
        int p;
        int prev = (p = this.rangeOf(--e)) >= 0 ? this.ELEMENTS[p - 1 << 1] - 1 : e;
        return prev;
    }

    @Override
    public boolean contains(int o) {
        if (this.CARDINALITY == 1) {
            return this.ELEMENTS[0] == o;
        }
        return this.rangeOf(o) >= 0;
    }

    @Override
    public IntIterableRangeSet duplicate() {
        IntIterableRangeSet ir = new IntIterableRangeSet();
        ir.ELEMENTS = (int[])this.ELEMENTS.clone();
        ir.CARDINALITY = this.CARDINALITY;
        ir.SIZE = this.SIZE;
        this.checkInvariants();
        return ir;
    }

    public IntIterableRangeSet copyFrom(IntIterableRangeSet me) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        this.clear();
        for (int s = 0; s < me.SIZE; s += 2) {
            this.pushRange(me.ELEMENTS[s], me.ELEMENTS[s + 1]);
        }
        this.checkInvariants();
        return this;
    }

    public void copyFrom(IntVar var) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        this.clear();
        DisposableRangeIterator rit = var.getRangeIterator(true);
        while (rit.hasNext()) {
            int lb = rit.min();
            int ub = rit.max();
            this.pushRange(lb, ub);
            rit.next();
        }
        rit.dispose();
    }

    @Override
    public int size() {
        return this.CARDINALITY;
    }

    @Override
    public ISetIterator newIterator() {
        return new ISetIterator(){
            private boolean started = false;
            private int current;

            @Override
            public void reset() {
                this.started = false;
            }

            @Override
            public boolean hasNext() {
                if (this.started) {
                    return IntIterableRangeSet.this.nextValue(this.current) < Integer.MAX_VALUE;
                }
                return !IntIterableRangeSet.this.isEmpty();
            }

            @Override
            public int nextInt() {
                if (this.started) {
                    this.current = IntIterableRangeSet.this.nextValue(this.current);
                } else {
                    this.started = true;
                    this.current = IntIterableRangeSet.this.min();
                }
                return this.current;
            }
        };
    }

    @Override
    public void plus(int x) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int i = 0;
        while (i < this.SIZE) {
            int n = i++;
            this.ELEMENTS[n] = this.ELEMENTS[n] + x;
        }
    }

    @Override
    public ISetIterator iterator() {
        if (this.iter == null) {
            this.iter = this.newIterator();
        }
        this.iter.reset();
        return this.iter;
    }

    @Override
    public void minus(int x) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        int i = 0;
        while (i < this.SIZE) {
            int n = i++;
            this.ELEMENTS[n] = this.ELEMENTS[n] - x;
        }
        this.notifyObservingFullUpdate();
    }

    public void times(int x) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        if (x > 0) {
            int i = 0;
            while (i < this.SIZE) {
                int n = i++;
                this.ELEMENTS[n] = this.ELEMENTS[n] * x;
            }
            this.CARDINALITY *= x;
        } else if (x < 0) {
            for (int i = 0; i < this.SIZE >> 1; ++i) {
                int t = this.ELEMENTS[i];
                this.ELEMENTS[i] = this.ELEMENTS[this.SIZE - i - 1] * x;
                this.ELEMENTS[this.SIZE - i - 1] = t * x;
            }
            this.CARDINALITY *= -x;
        } else {
            this.clear();
            this.add(0);
        }
        this.notifyObservingFullUpdate();
    }

    public int rangeOf(int x) {
        return this.rangeOf(x, 0, this.SIZE);
    }

    protected int rangeOf(int x, int fromIndex, int toIndex) {
        if (toIndex - fromIndex < 15) {
            int q = -((toIndex >> 1) + 1);
            for (int r = fromIndex; r < toIndex - 1; r += 2) {
                if (x < this.ELEMENTS[r]) {
                    q = -((r >> 1) + 1);
                    break;
                }
                if (x > this.ELEMENTS[r + 1]) continue;
                q = (r >> 1) + 1;
                break;
            }
            return q;
        }
        int p = Arrays.binarySearch(this.ELEMENTS, fromIndex, toIndex, x);
        if (p >= 0) {
            p >>= 1;
        } else if (p == -1) {
            --p;
        } else if (p == -(toIndex + 1)) {
            p = -((toIndex >> 1) + 2);
        } else {
            p = -(p + 1);
            if (this.ELEMENTS[(p >>= 1) << 1] >= x || x >= this.ELEMENTS[(p << 1) + 1]) {
                p = -(p + 2);
            }
        }
        return p + 1;
    }

    void grow(int minCapacity) {
        if (minCapacity - this.ELEMENTS.length > 0) {
            int oldCapacity = this.ELEMENTS.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            this.ELEMENTS = Arrays.copyOf(this.ELEMENTS, newCapacity);
        }
    }

    void pushRange(int lb, int ub) {
        assert (this.SIZE == 0 || this.ELEMENTS[this.SIZE - 1] < lb - 1);
        assert (lb <= ub);
        this.grow(this.SIZE + 2);
        this.ELEMENTS[this.SIZE++] = lb;
        this.ELEMENTS[this.SIZE++] = ub;
        this.CARDINALITY += Math.addExact(ub + 1, -lb);
        this.notifyObservingFullUpdate();
    }

    public void compact() {
        this.ELEMENTS = Arrays.copyOf(this.ELEMENTS, this.SIZE);
    }

    public IntIterableRangeSet flip() {
        return this.flip(-1073741823, 0x3FFFFFFF);
    }

    public IntIterableRangeSet flip(int lb, int ub) {
        if (this.lock) {
            throw new IllegalStateException("This set is immutable");
        }
        if (this.SIZE == 0) {
            this.pushRange(lb, ub);
        } else if (this.ELEMENTS[0] <= lb && this.ELEMENTS[1] >= ub) {
            this.clear();
        } else {
            boolean emax;
            boolean smin = this.ELEMENTS[0] <= lb;
            boolean bl = emax = this.ELEMENTS[this.SIZE - 1] >= ub;
            if (!smin && !emax) {
                this.grow(this.SIZE + 2);
                this.SIZE += 2;
            }
            if (smin && emax) {
                this.SIZE -= 2;
            }
            this.CARDINALITY = 0;
            if (smin) {
                int max;
                int i = 1;
                int n = max = emax ? this.SIZE : this.SIZE - 2;
                while (i < max) {
                    this.ELEMENTS[i - 1] = this.ELEMENTS[i++] + 1;
                    this.ELEMENTS[i - 1] = this.ELEMENTS[i++] - 1;
                    this.CARDINALITY += this.ELEMENTS[i - 2] - this.ELEMENTS[i - 3] + 1;
                }
                if (!emax) {
                    this.ELEMENTS[i - 1] = this.ELEMENTS[i++] + 1;
                    this.ELEMENTS[i - 1] = ub;
                    this.CARDINALITY += this.ELEMENTS[i - 1] - this.ELEMENTS[i - 2] + 1;
                }
            } else {
                int i = this.SIZE - 1;
                this.ELEMENTS[i--] = !emax ? ub : this.ELEMENTS[i] - 1;
                while (i > 0) {
                    this.ELEMENTS[i--] = this.ELEMENTS[i] + 1;
                    this.CARDINALITY += this.ELEMENTS[i + 2] - this.ELEMENTS[i + 1] + 1;
                    this.ELEMENTS[i--] = this.ELEMENTS[i] - 1;
                }
                this.ELEMENTS[i] = lb;
                this.CARDINALITY += this.ELEMENTS[i + 1] - this.ELEMENTS[i] + 1;
            }
        }
        this.notifyObservingFullUpdate();
        return this;
    }

    public boolean intersect(int lb, int ub) {
        if (this.CARDINALITY > 100) {
            return this.intersectDichot(lb, ub);
        }
        int s1 = this.SIZE >> 1;
        int s2 = ub - lb + 1;
        if (s1 > 0 && s2 > 0) {
            int i = 0;
            int lbi = this.ELEMENTS[0];
            int ubi = this.ELEMENTS[1];
            while (true) {
                if (lbi <= lb && lb <= ubi || lb <= lbi && lbi <= ub) {
                    return true;
                }
                if (ubi > ub || ++i >= s1) break;
                lbi = this.ELEMENTS[i << 1];
                ubi = this.ELEMENTS[(i << 1) + 1];
            }
        }
        return false;
    }

    public boolean intersectDichot(int lb, int ub) {
        int rlb = this.rangeOf(lb);
        if (rlb > 0) {
            return true;
        }
        int rub = this.rangeOf(ub, -rlb - 1 << 1, this.SIZE);
        if (rub > 0) {
            return true;
        }
        return rlb != rub;
    }

    public boolean intersect(IntIterableRangeSet set) {
        int s1 = this.SIZE >> 1;
        int s2 = set.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int i = 0;
            int j = 0;
            int lbi = this.ELEMENTS[0];
            int ubi = this.ELEMENTS[1];
            int lbj = set.ELEMENTS[0];
            int ubj = set.ELEMENTS[1];
            while (i < s1 && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    return true;
                }
                if (ubi <= ubj && ++i < s1) {
                    lbi = this.ELEMENTS[i << 1];
                    ubi = this.ELEMENTS[(i << 1) + 1];
                    continue;
                }
                if (ubj > ubi || ++j >= s2) continue;
                lbj = set.ELEMENTS[j << 1];
                ubj = set.ELEMENTS[(j << 1) + 1];
            }
        }
        return false;
    }

    public boolean intersect(IntVar var) {
        int s1 = var.getDomainSize();
        int s2 = this.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int j = 0;
            int lbi = var.getLB();
            int ubi = var.nextValueOut(lbi) - 1;
            int lbj = this.ELEMENTS[0];
            int ubj = this.ELEMENTS[1];
            while (lbi < Integer.MAX_VALUE && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    return true;
                }
                if (ubi <= ubj && (lbi = var.nextValue(ubi)) < Integer.MAX_VALUE) {
                    ubi = var.nextValueOut(lbi) - 1;
                    continue;
                }
                if (ubj > ubi || ++j >= s2) continue;
                lbj = this.ELEMENTS[j << 1];
                ubj = this.ELEMENTS[(j << 1) + 1];
            }
        }
        return false;
    }

    public void forEachValueIn(IntConsumer c) {
        for (int s = 0; s < this.SIZE; s += 2) {
            for (int i = this.ELEMENTS[s]; i <= this.ELEMENTS[s + 1]; ++i) {
                c.accept(i);
            }
        }
    }

    public void forEachValueOut(IntConsumer c) {
        for (int s = 1; s < this.SIZE - 1; s += 2) {
            for (int i = this.ELEMENTS[s] + 1; i < this.ELEMENTS[s + 1]; ++i) {
                c.accept(i);
            }
        }
    }

    @Override
    public int[] toArray() {
        int[] a2 = new int[this.CARDINALITY];
        int k = 0;
        for (int i = 0; i < this.SIZE - 1; i += 2) {
            if (this.ELEMENTS[i] == this.ELEMENTS[i + 1]) {
                a2[k++] = this.ELEMENTS[i];
                continue;
            }
            int j = this.ELEMENTS[i];
            while (j <= this.ELEMENTS[i + 1]) {
                a2[k++] = j++;
            }
        }
        return a2;
    }
}

