/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.cost.trees;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropTreeCostSimple
extends Propagator<UndirectedGraphVar> {
    protected UndirectedGraphVar g;
    private final IGraphDeltaMonitor gdm;
    private final PairProcedure edgeEnf;
    private final PairProcedure edgeRem;
    protected int n;
    protected IntVar sum;
    protected int[][] distMatrix;
    private final IStateInt minSum;
    private final IStateInt maxSum;

    public PropTreeCostSimple(UndirectedGraphVar graph, IntVar obj, int[][] costMatrix) {
        super((Variable[])new UndirectedGraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.sum = obj;
        this.n = this.g.getNbMaxNodes();
        this.distMatrix = costMatrix;
        IEnvironment environment = graph.getEnvironment();
        this.minSum = environment.makeInt(0);
        this.maxSum = environment.makeInt(0);
        this.gdm = this.g.monitorDelta(this);
        this.edgeEnf = (i, j) -> this.minSum.add(this.distMatrix[i][j]);
        this.edgeRem = (i, j) -> this.maxSum.add(-this.distMatrix[i][j]);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getPotentialNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i > j) continue;
                max += this.distMatrix[i][j];
                if (!this.g.getMandatoryNeighborsOf(i).contains(j)) continue;
                min += this.distMatrix[i][j];
            }
        }
        this.minSum.set(min);
        this.maxSum.set(max);
        this.sum.updateLowerBound(min, this);
        this.sum.updateUpperBound(max, this);
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this.edgeEnf, GraphEventType.ADD_EDGE);
        this.gdm.forEachEdge(this.edgeRem, GraphEventType.REMOVE_EDGE);
        this.sum.updateLowerBound(this.minSum.get(), this);
        this.sum.updateUpperBound(this.maxSum.get(), this);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public ESat isEntailed() {
        int min = 0;
        int max = 0;
        for (int i = 0; i < this.n; ++i) {
            ISet nei = this.g.getPotentialNeighborsOf(i);
            ISetIterator iSetIterator = nei.iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i > j) continue;
                max += this.distMatrix[i][j];
                if (!this.g.getMandatoryNeighborsOf(i).contains(j)) continue;
                min += this.distMatrix[i][j];
            }
        }
        if (min > this.sum.getUB() || max < this.sum.getLB()) {
            return ESat.FALSE;
        }
        if (min == max) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

