/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropNeighSetsChannel1
extends Propagator<GraphVar<?>> {
    private final int n;
    private final SetVar[] sets;
    private final IGraphDeltaMonitor gdm;
    private final GraphVar<?> g;
    private final PairProcedure arcForced;
    private final PairProcedure arcRemoved;

    public PropNeighSetsChannel1(SetVar[] setsV, GraphVar<?> gV) {
        super((Variable[])new GraphVar[]{gV}, (Priority)PropagatorPriority.LINEAR, true);
        this.sets = setsV;
        this.n = this.sets.length;
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
        this.gdm = this.g.monitorDelta(this);
        this.arcForced = (i, j) -> {
            this.sets[i].force(j, this);
            if (!this.g.isDirected()) {
                this.sets[j].force(i, this);
            }
        };
        this.arcRemoved = (i, j) -> {
            this.sets[i].remove(j, this);
            if (!this.g.isDirected()) {
                this.sets[j].remove(i, this);
            }
        };
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            int j;
            ISet tmp = this.g.getMandatorySuccessorsOf(i);
            ISetIterator iSetIterator = tmp.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                this.sets[i].force(j, this);
                if (this.g.isDirected()) continue;
                this.sets[j].force(i, this);
            }
            iSetIterator = this.sets[i].getUB().iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.g.getPotentialSuccessorsOf(i).contains(j)) continue;
                this.sets[i].remove(j, this);
                if (this.g.isDirected()) continue;
                this.sets[j].remove(i, this);
            }
        }
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.gdm.forEachEdge(this.arcForced, GraphEventType.ADD_EDGE);
        this.gdm.forEachEdge(this.arcRemoved, GraphEventType.REMOVE_EDGE);
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            ISetIterator iSetIterator = this.sets[i].getLB().iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (this.g.getPotentialSuccessorsOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
            ISet tmp = this.g.getMandatorySuccessorsOf(i);
            ISetIterator iSetIterator2 = tmp.iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.sets[i].getUB().contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

