% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoSQLResourceClient.R
\docType{class}
\name{NoSQLResourceClient}
\alias{NoSQLResourceClient}
\title{NoSQL database resource client}
\format{A R6 object of class NoSQLResourceClient}
\description{
NoSQL database resource client

NoSQL database resource client
}
\details{
Resource client that connects to a NoSQL database supported by nodbi.
}
\section{Super class}{
\code{\link[resourcer:ResourceClient]{resourcer::ResourceClient}} -> \code{NoSQLResourceClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{NoSQLResourceClient$new()}}
\item \href{#method-getConnection}{\code{NoSQLResourceClient$getConnection()}}
\item \href{#method-asDataFrame}{\code{NoSQLResourceClient$asDataFrame()}}
\item \href{#method-getDatabaseName}{\code{NoSQLResourceClient$getDatabaseName()}}
\item \href{#method-getTableName}{\code{NoSQLResourceClient$getTableName()}}
\item \href{#method-close}{\code{NoSQLResourceClient$close()}}
\item \href{#method-clone}{\code{NoSQLResourceClient$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="asTbl">}\href{../../resourcer/html/ResourceClient.html#method-asTbl}{\code{resourcer::ResourceClient$asTbl()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="downloadFile">}\href{../../resourcer/html/ResourceClient.html#method-downloadFile}{\code{resourcer::ResourceClient$downloadFile()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="exec">}\href{../../resourcer/html/ResourceClient.html#method-exec}{\code{resourcer::ResourceClient$exec()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="resourcer" data-topic="ResourceClient" data-id="getResource">}\href{../../resourcer/html/ResourceClient.html#method-getResource}{\code{resourcer::ResourceClient$getResource()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Creates a new NoSQLResourceClient instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$new(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A NoSQLResourceClient object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getConnection"></a>}}
\subsection{Method \code{getConnection()}}{
Creates the nodbi connection object if it does not exist.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$getConnection()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The nodbi connection object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-asDataFrame"></a>}}
\subsection{Method \code{asDataFrame()}}{
Makes a data.frame from the remote database table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$asDataFrame()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A tibble.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDatabaseName"></a>}}
\subsection{Method \code{getDatabaseName()}}{
Extract the database name from the resource URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$getDatabaseName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The database name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTableName"></a>}}
\subsection{Method \code{getTableName()}}{
Extract the database table name from the resource URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$getTableName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The database table name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\subsection{Method \code{close()}}{
Close the nodbi connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NoSQLResourceClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
