% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keywords.R
\name{key_words}
\alias{key_words}
\title{Convert a CF Standard Name to/from a GCMD Science Keyword}
\usage{
key_words(cf = NULL, gcmd = NULL, url = eurl(), ...)
}
\arguments{
\item{cf}{character; A cf standard name
http://cfconventions.org/Data/cf-standard-names/27/build/cf-standard-name-table.html}

\item{gcmd}{character; A GCMD science keyword
http://gcmd.gsfc.nasa.gov/learn/keyword_list.html}

\item{url}{A URL for an ERDDAP server. Default:
https://upwell.pfeg.noaa.gov/erddap/. See \code{\link[=eurl]{eurl()}} for
more information}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\description{
Convert a CF Standard Name to/from a GCMD Science Keyword
}
\examples{
 \dontrun{
key_words(cf = "air_pressure")
cat(key_words(cf = "air_pressure"))

# a different ERDDAP server
# key_words(cf = "air_pressure", url = servers()$url[6])
}
}
