% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{.cacheMessage}
\alias{.cacheMessage}
\alias{.cacheMessage,ANY-method}
\title{Create a custom cache message by class}
\usage{
.cacheMessage(
  object,
  functionName,
  fromMemoise = getOption("reproducible.useMemoise", TRUE),
  verbose = getOption("reproducible.verbose", 1)
)

\S4method{.cacheMessage}{ANY}(
  object,
  functionName,
  fromMemoise = getOption("reproducible.useMemoise", TRUE),
  verbose = getOption("reproducible.verbose", 1)
)
}
\arguments{
\item{object}{Any R object.}

\item{functionName}{A character string indicating the function name}

\item{fromMemoise}{Logical. If \code{TRUE}, the message will be about
recovery from memoised copy}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \code{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
Nothing; called for its messaging side effect.
}
\description{
This is a generic definition that can be extended according to class.
}
\examples{
a <- 1
.cacheMessage(a, "mean")

}
\author{
Eliot McIntire
}
